<?php $__env->startSection('title', 'Messages & Notifications'); ?>
<?php $__env->startSection('page-title', 'Messages & Notifications'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">Messages & Notifications</h1>
            <p class="mt-1 text-sm text-gray-600">View your notifications and messages</p>
        </div>
        <div class="mt-4 sm:mt-0 flex gap-2">
            <?php if($unreadNotifications > 0): ?>
                <form action="<?php echo e(route('student.messages.mark-all-notifications-read')); ?>" method="POST" class="inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="px-3 py-1.5 text-xs font-medium text-white bg-indigo-600 rounded hover:bg-indigo-700">
                        Mark All Notifications Read
                    </button>
                </form>
            <?php endif; ?>
            <?php if($unreadMessages > 0): ?>
                <form action="<?php echo e(route('student.messages.mark-all-messages-read')); ?>" method="POST" class="inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="px-3 py-1.5 text-xs font-medium text-white bg-indigo-600 rounded hover:bg-indigo-700">
                        Mark All Messages Read
                    </button>
                </form>
            <?php endif; ?>
        </div>
    </div>

    <!-- Summary Cards -->
    <div class="grid grid-cols-2 gap-4 mb-6">
        <div class="bg-white rounded-lg shadow p-4">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Notifications</p>
                    <p class="text-2xl font-bold text-gray-900 mt-1"><?php echo e($notifications->total()); ?></p>
                </div>
                <?php if($unreadNotifications > 0): ?>
                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">
                        <?php echo e($unreadNotifications); ?> unread
                    </span>
                <?php endif; ?>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow p-4">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Messages</p>
                    <p class="text-2xl font-bold text-gray-900 mt-1"><?php echo e($messages->total()); ?></p>
                </div>
                <?php if($unreadMessages > 0): ?>
                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-red-100 text-red-800">
                        <?php echo e($unreadMessages); ?> unread
                    </span>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Tabs -->
    <div class="bg-white rounded-lg shadow-sm mb-6">
        <div class="border-b border-gray-200">
            <nav class="flex -mb-px" aria-label="Tabs">
                <button onclick="showTab('notifications')" id="tab-notifications" class="tab-button active px-6 py-3 text-sm font-medium border-b-2 border-indigo-500 text-indigo-600">
                    Notifications
                    <?php if($unreadNotifications > 0): ?>
                        <span class="ml-2 px-2 py-0.5 text-xs rounded-full bg-red-100 text-red-800"><?php echo e($unreadNotifications); ?></span>
                    <?php endif; ?>
                </button>
                <button onclick="showTab('messages')" id="tab-messages" class="tab-button px-6 py-3 text-sm font-medium border-b-2 border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300">
                    Messages
                    <?php if($unreadMessages > 0): ?>
                        <span class="ml-2 px-2 py-0.5 text-xs rounded-full bg-red-100 text-red-800"><?php echo e($unreadMessages); ?></span>
                    <?php endif; ?>
                </button>
            </nav>
        </div>

        <!-- Notifications Tab -->
        <div id="notifications-content" class="tab-content">
            <?php if($notifications->count() > 0): ?>
                <div class="divide-y divide-gray-200">
                    <?php $__currentLoopData = $notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notification): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="p-4 hover:bg-gray-50 <?php echo e(!$notification->read_at ? 'bg-blue-50' : ''); ?>">
                            <div class="flex items-start justify-between">
                                <div class="flex-1">
                                    <div class="flex items-center space-x-2 flex-wrap">
                                        <?php if(!$notification->read_at): ?>
                                            <span class="h-2 w-2 bg-blue-600 rounded-full flex-shrink-0"></span>
                                        <?php endif; ?>
                                        <p class="text-sm font-medium text-gray-900">
                                            <?php echo e($notification->data['title'] ?? 'Notification'); ?>

                                        </p>
                                        <?php
                                            $sender = $notificationSenders[$notification->id] ?? null;
                                        ?>
                                        <?php if($sender): ?>
                                            <span class="text-xs text-gray-500">
                                                from 
                                                <span class="font-medium text-gray-700"><?php echo e($sender->name); ?></span>
                                                <?php if($sender->role): ?>
                                                    <span class="px-1.5 py-0.5 text-xs rounded bg-gray-100 text-gray-600 ml-1">
                                                        <?php echo e(ucfirst(str_replace('_', ' ', $sender->role))); ?>

                                                    </span>
                                                <?php endif; ?>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                    <p class="mt-1 text-sm text-gray-600">
                                        <?php echo e($notification->data['message'] ?? $notification->data['body'] ?? 'No message content'); ?>

                                    </p>
                                    <p class="mt-1 text-xs text-gray-500">
                                        <?php echo e($notification->created_at->diffForHumans()); ?>

                                    </p>
                                </div>
                                <div class="ml-4 flex items-center space-x-2">
                                    <a href="<?php echo e(route('student.messages.show-notification', $notification->id)); ?>" class="text-indigo-600 hover:text-indigo-900 text-sm">
                                        View
                                    </a>
                                    <?php if(!$notification->read_at): ?>
                                        <form action="<?php echo e(route('student.messages.mark-notification-read', $notification->id)); ?>" method="POST" class="inline">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="text-gray-500 hover:text-gray-700 text-sm">
                                                Mark Read
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="px-6 py-4 border-t border-gray-200">
                    <?php echo e($notifications->links()); ?>

                </div>
            <?php else: ?>
                <div class="p-12 text-center">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                    </svg>
                    <h3 class="mt-2 text-sm font-medium text-gray-900">No notifications</h3>
                    <p class="mt-1 text-sm text-gray-500">You don't have any notifications yet.</p>
                </div>
            <?php endif; ?>
        </div>

        <!-- Messages Tab -->
        <div id="messages-content" class="tab-content hidden">
            <?php if($messages->count() > 0): ?>
                <div class="divide-y divide-gray-200">
                    <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="p-4 hover:bg-gray-50 <?php echo e(!$message->is_read ? 'bg-blue-50' : ''); ?>">
                            <div class="flex items-start justify-between">
                                <div class="flex-1">
                                    <div class="flex items-center space-x-2">
                                        <?php if(!$message->is_read): ?>
                                            <span class="h-2 w-2 bg-blue-600 rounded-full"></span>
                                        <?php endif; ?>
                                        <p class="text-sm font-medium text-gray-900">
                                            <?php echo e($message->subject); ?>

                                        </p>
                                        <span class="text-xs text-gray-500">
                                            from <?php echo e($message->sender->name); ?>

                                            <?php if($message->sender->role): ?>
                                                <span class="px-1.5 py-0.5 text-xs rounded bg-gray-100 text-gray-600">
                                                    <?php echo e(ucfirst($message->sender->role)); ?>

                                                </span>
                                            <?php endif; ?>
                                        </span>
                                    </div>
                                    <p class="mt-1 text-sm text-gray-600 line-clamp-2">
                                        <?php echo e(Str::limit($message->body, 150)); ?>

                                    </p>
                                    <p class="mt-1 text-xs text-gray-500">
                                        <?php echo e($message->created_at->diffForHumans()); ?>

                                    </p>
                                </div>
                                <div class="ml-4 flex items-center space-x-2">
                                    <a href="<?php echo e(route('student.messages.show-message', $message->id)); ?>" class="text-indigo-600 hover:text-indigo-900 text-sm">
                                        View
                                    </a>
                                    <?php if(!$message->is_read): ?>
                                        <form action="<?php echo e(route('student.messages.mark-message-read', $message->id)); ?>" method="POST" class="inline">
                                            <?php echo csrf_field(); ?>
                                            <button type="submit" class="text-gray-500 hover:text-gray-700 text-sm">
                                                Mark Read
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="px-6 py-4 border-t border-gray-200">
                    <?php echo e($messages->links()); ?>

                </div>
            <?php else: ?>
                <div class="p-12 text-center">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8M5 19h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                    </svg>
                    <h3 class="mt-2 text-sm font-medium text-gray-900">No messages</h3>
                    <p class="mt-1 text-sm text-gray-500">You don't have any messages yet.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <script>
        function showTab(tab) {
            // Hide all tab contents
            document.querySelectorAll('.tab-content').forEach(content => {
                content.classList.add('hidden');
            });
            
            // Remove active class from all tabs
            document.querySelectorAll('.tab-button').forEach(button => {
                button.classList.remove('active', 'border-indigo-500', 'text-indigo-600');
                button.classList.add('border-transparent', 'text-gray-500');
            });
            
            // Show selected tab content
            document.getElementById(tab + '-content').classList.remove('hidden');
            
            // Add active class to selected tab
            const selectedTab = document.getElementById('tab-' + tab);
            selectedTab.classList.add('active', 'border-indigo-500', 'text-indigo-600');
            selectedTab.classList.remove('border-transparent', 'text-gray-500');
        }
    </script>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.student', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/student/messages/index.blade.php ENDPATH**/ ?>