# Assessor Tool Digital Marking System - Implementation Guide

## Overview
This feature allows trainers to convert paper-based assessor tools into editable digital formats, enter marks digitally, and regenerate completed assessor tools matching the original layout.

## Architecture

### Database Structure

#### 1. `assessor_tool_structures` Table
Stores the parsed/structured version of assessor tools:
- `assignment_id` - Links to the practical assignment
- `structure` (JSON) - Stores sections, rows, max marks, item descriptions
- `original_file_path` - Reference to original uploaded file
- `total_marks` - Calculated total marks available
- `header_data` (JSON) - Header information (candidate name, assessor name, venue, date)

#### 2. `assessor_tool_marks` Table
Stores marks entered by trainers for each submission:
- `assignment_id` - Links to assignment
- `assignment_submission_id` - Links to specific student submission
- `structure_id` - Links to the structure
- `row_identifier` - Unique identifier for each row/item
- `section` - Section/group name (e.g., "TASK 1")
- `item_description` - Description of item being evaluated
- `marks_available` - Maximum marks for this item
- `marks_obtained` - Marks awarded
- `comments` - Trainer comments/observations
- `display_order` - Order for display

### Models

1. **AssessorToolStructure** - Manages structure data
2. **AssessorToolMark** - Manages marks data
3. **Assignment** - Added relationship: `assessorToolStructure()`
4. **AssignmentSubmission** - Added relationship: `assessorToolMarks()` and `graded_at` field

### Services

1. **AssessorToolParserService** - Parses Word/PDF documents (optional, requires packages)
   - `parseDocument()` - Main parsing method
   - `parseWordDocument()` - Parses Word documents
   - `parsePdfDocument()` - Parses PDF documents
   - Note: Currently works with manual entry. Auto-parsing requires:
     - `composer require phpoffice/phpword`
     - `composer require smalot/pdfparser`

2. **AssessorToolGeneratorService** - Generates completed documents
   - `generate()` - Creates PDF/HTML document with marks filled in
   - Uses `barryvdh/laravel-dompdf` (already installed)

### Controllers

**AssessorToolController** (`app/Http/Controllers/Trainer/AssessorToolController.php`):
- `createStructure()` - Show structure creation form
- `storeStructure()` - Save structure (manual or auto-parse)
- `marking()` - Show marking interface
- `saveMarks()` - Save marks via AJAX
- `generateDocument()` - Generate completed assessor tool PDF

### Routes

All routes are under `/trainer/assignments/{assignment}/assessor-tool/`:
- `GET /structure` - Create/edit structure
- `POST /structure` - Store structure
- `GET /marking` - Marking interface (no submission selected)
- `GET /marking/{submissionId}` - Marking interface (specific submission)
- `POST /submissions/{submission}/marks` - Save marks
- `GET /submissions/{submission}/generate` - Generate completed document

### Views

1. **create-structure.blade.php** - Structure creation/editing
   - Manual entry tab (always available)
   - Auto-parse tab (requires packages)
   - Dynamic item addition/removal
   - Header data configuration

2. **marking.blade.php** - Editable marking interface
   - Submission selector dropdown
   - Table matching original layout
   - Real-time total calculation (Alpine.js)
   - Auto-save functionality
   - Section grouping support

3. **generated-document.blade.php** - PDF template
   - Matches original document layout
   - Header information
   - Table with marks filled in
   - Section subtotals and overall total

## Workflow

### 1. Structure Creation
1. Trainer navigates to practical assignment
2. Clicks "Manage Structure" or "Mark Assessor Tool"
3. Creates structure either:
   - **Manual Entry**: Add items row by row with descriptions and max marks
   - **Auto Parse**: Upload Word/PDF document (if packages installed)
4. Structure is saved to database

### 2. Marking Process
1. Trainer selects submission from dropdown
2. System loads structure and any existing marks
3. Trainer enters marks row by row
4. System validates marks (cannot exceed max)
5. Real-time total calculation
6. Marks saved via AJAX
7. Submission status updated to "graded"

### 3. Document Generation
1. After marking, trainer clicks "Generate Document"
2. System creates PDF matching original layout
3. Marks and totals are filled in
4. Document is downloadable
5. Suitable for CDACC submission

## Access Control

- **Trainers**: Can create structure, enter marks, generate documents
- **Students**: Can only view completed assessor tool after marks are finalized
- **Original File**: Remains unchanged as reference

## Installation Steps

1. **Run Migrations**:
   ```bash
   php artisan migrate
   ```

2. **Install Optional Packages** (for auto-parsing):
   ```bash
   composer require phpoffice/phpword
   composer require smalot/pdfparser
   ```
   Note: Manual entry works without these packages.

3. **Clear Caches**:
   ```bash
   php artisan route:clear
   php artisan view:clear
   php artisan config:clear
   ```

## Usage

### For Trainers:

1. **Create Structure**:
   - Go to practical assignment
   - Click "Manage Structure"
   - Enter items manually or upload document
   - Save structure

2. **Mark Submissions**:
   - Go to assignment → Click "Mark Assessor Tool"
   - Select submission from dropdown
   - Enter marks and comments
   - Save marks
   - Generate completed document

### For Students:

- View completed assessor tool after trainer awards marks
- Download generated document with marks filled in

## Features

✅ Manual structure entry (no packages required)
✅ Auto-parsing from Word/PDF (optional, requires packages)
✅ Editable marking interface with real-time calculations
✅ Section grouping support
✅ Validation (marks cannot exceed max)
✅ Auto-save functionality
✅ Document regeneration matching original layout
✅ PDF generation for CDACC submission
✅ Access control (trainers edit, students view only)

## Notes

- The system works **immediately with manual entry** - no packages needed
- Auto-parsing can be added later when packages are installed
- Original assessor tool files remain unchanged
- Candidate tool is not modified
- All marks are stored in database for audit trail
- Generated documents match original layout exactly

