# E-PoE System Deployment Guide - TrueHost with PostgreSQL

This guide provides step-by-step instructions for deploying the E-PoE (Electronic Portfolio of Evidence) system to TrueHost using PostgreSQL as the database.

## Table of Contents

1. [Prerequisites](#prerequisites)
2. [TrueHost Account Setup](#truehost-account-setup)
3. [PostgreSQL Database Setup](#postgresql-database-setup)
4. [Application Deployment](#application-deployment)
5. [Building Vite Assets for Production](#building-vite-assets-for-production)
6. [Environment Configuration](#environment-configuration)
7. [File Permissions](#file-permissions)
8. [Database Migration](#database-migration)
9. [Application Optimization](#application-optimization)
10. [Security Configuration](#security-configuration)
11. [Troubleshooting](#troubleshooting)
12. [Post-Deployment Checklist](#post-deployment-checklist)

---

## Prerequisites

Before starting, ensure you have:

- ✅ TrueHost hosting account with cPanel access
- ✅ PostgreSQL database access enabled on your TrueHost plan
- ✅ FTP/SFTP credentials or cPanel File Manager access
- ✅ SSH access (if available on your plan)
- ✅ Domain name configured and pointing to TrueHost
- ✅ Local development environment with the application ready
- ✅ Composer installed locally (for dependency management)
- ✅ Node.js and npm installed locally (for building Vite assets)

---

## TrueHost Account Setup

### 1. Access cPanel

1. Log in to your TrueHost account
2. Navigate to **cPanel** (usually at `https://yourdomain.com/cpanel` or provided URL)
3. Verify your hosting plan includes PostgreSQL support

### 2. Check PHP Version

1. In cPanel, go to **Select PHP Version** or **MultiPHP Manager**
2. Ensure PHP version is **8.0 or higher** (recommended: PHP 8.1 or 8.2)
3. Enable the following PHP extensions:
   - `pdo_pgsql`
   - `pgsql`
   - `mbstring`
   - `openssl`
   - `tokenizer`
   - `xml`
   - `ctype`
   - `json`
   - `fileinfo`
   - `gd` (for image processing)
   - `zip` (for backups)
   - `curl`

### 3. Enable Required Apache Modules

If you have access to Apache modules, ensure these are enabled:
- `mod_rewrite` (for Laravel routing)
- `mod_headers` (for security headers)

---

## PostgreSQL Database Setup

### 1. Create PostgreSQL Database

1. In cPanel, navigate to **PostgreSQL Databases**
2. Click **Create Database**
3. Enter a database name (e.g., `epoe_db` or `yourdomain_epoe`)
4. Click **Create Database**
5. **Note down the full database name** (usually includes your cPanel username prefix)

### 2. Create Database User

1. Scroll down to **Add New User**
2. Enter a username (e.g., `epoe_user`)
3. Enter a **strong password** (save this securely)
4. Click **Create User**
5. **Note down the full username** (usually includes your cPanel username prefix)

### 3. Grant User Privileges

1. Scroll to **Add User To Database**
2. Select the user you created
3. Select the database you created
4. Click **Add**
5. Ensure **ALL PRIVILEGES** are granted (check the checkbox if available)

### 4. Note Database Connection Details

You'll need these details for your `.env` file:

```
DB_CONNECTION=pgsql
DB_HOST=localhost (or the provided PostgreSQL host)
DB_PORT=5432
DB_DATABASE=your_full_database_name
DB_USERNAME=your_full_username
DB_PASSWORD=your_password
```

**Important:** TrueHost may use a different host for PostgreSQL. Check your cPanel for the exact PostgreSQL hostname (it might be `localhost` or something like `postgres.yourdomain.com`).

---

## Application Deployment

### 1. Prepare Application for Production

#### On Your Local Machine:

```bash
# Navigate to your project directory
cd /path/to/your/poe/project

# Install production dependencies (without dev dependencies)
composer install --optimize-autoloader --no-dev

# Build Vite assets for production (IMPORTANT: Do this before uploading)
npm install
npm run build

# Clear and optimize Laravel caches
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear

# Generate optimized autoload files
composer dump-autoload --optimize
```

**Important:** Always run `npm run build` before uploading files to production. This creates optimized CSS and JavaScript files in the `public/build/` directory. See [Building Vite Assets for Production](#building-vite-assets-for-production) section for detailed instructions.

### 2. Upload Files to TrueHost

#### Option A: Using FTP/SFTP Client (Recommended)

1. Use an FTP client like **FileZilla**, **WinSCP**, or **Cyberduck**
2. Connect using your FTP credentials from cPanel
3. Navigate to your domain's public directory:
   - Usually: `/public_html/` or `/public_html/yourdomain.com/`
   - For subdomain: `/public_html/subdomain/`
4. Upload all files **except**:
   - `.env` (we'll create this on the server)
   - `node_modules/` (if present - not needed on server)
   - `.git/` directory
   - `storage/logs/*.log` files
   - `storage/framework/cache/*` files
   - `storage/framework/sessions/*` files
   - `storage/framework/views/*` files
   - `package.json`, `package-lock.json`, `vite.config.js` (optional - not needed if you've already built assets)
   
**Important:** Make sure to upload the `public/build/` directory after running `npm run build` locally. This directory contains your compiled CSS and JavaScript files.

#### Option B: Using cPanel File Manager

1. In cPanel, go to **File Manager**
2. Navigate to `public_html/` or your domain directory
3. Upload a ZIP file of your application
4. Extract the ZIP file
5. Delete the ZIP file after extraction

### 3. Set Correct Directory Structure

Ensure your files are in the correct location:

```
public_html/
├── app/
├── bootstrap/
├── config/
├── database/
├── public/          ← This should be your document root
│   ├── index.php
│   ├── .htaccess
│   └── ...
├── resources/
├── routes/
├── storage/
├── vendor/
├── .env
├── .htaccess        ← Root .htaccess for Laravel
├── artisan
└── composer.json
```

**Important:** If TrueHost requires files in `public_html/`, you may need to:
- Move contents of `public/` to `public_html/`
- Update paths in `public_html/index.php` to point to parent directories
- Or configure document root to point to `public/` directory

### 4. Build Vite Assets for Production

**Important:** In production, you **DO NOT** run `npm run dev`. Instead, you need to build the assets using `npm run build` on your local machine and upload the built files.

#### Step 1: Build Assets Locally

On your local development machine:

```bash
# Navigate to your project directory
cd /path/to/your/poe/project

# Install npm dependencies (if not already installed)
npm install

# Build assets for production (this creates optimized, minified files)
npm run build
```

This command will:
- Compile and minify your CSS and JavaScript
- Generate optimized production assets
- Create a `public/build/` directory with the compiled files
- Generate a `public/build/.vite/manifest.json` file

#### Step 2: Upload Built Assets

After running `npm run build`, you need to upload the `public/build/` directory to your server:

**Option A: Upload via FTP/SFTP**
1. Connect to your server via FTP/SFTP
2. Navigate to `public_html/public/` (or wherever your `public/` directory is)
3. Upload the entire `build/` folder from your local `public/build/` directory
4. Ensure the `build/` directory structure is:
   ```
   public/
   └── build/
       ├── assets/
       │   ├── app-[hash].js
       │   └── app-[hash].css
       └── .vite/
           └── manifest.json
   ```

**Option B: Upload via cPanel File Manager**
1. In cPanel, go to **File Manager**
2. Navigate to `public_html/public/` directory
3. Upload the `build/` folder (you can zip it first, then extract on server)
4. Ensure permissions are set correctly (755 for directories, 644 for files)

#### Step 3: Verify Asset Loading

After uploading, verify that:
- The `public/build/` directory exists on the server
- The `public/build/.vite/manifest.json` file exists
- Your website loads CSS and JavaScript correctly (check browser console for errors)

#### Alternative: Build on Server (If Node.js is Available)

If TrueHost provides Node.js access via SSH or cPanel:

```bash
# SSH into your server
ssh username@yourdomain.com

# Navigate to your application directory
cd /home/username/public_html

# Install npm dependencies
npm install

# Build assets for production
npm run build
```

**Note:** Most shared hosting providers (including TrueHost) don't provide Node.js access. Building locally and uploading is the recommended approach.

#### Troubleshooting Vite Assets

**Issue: Assets not loading (404 errors)**
- Verify `public/build/` directory exists and contains files
- Check that `public/build/.vite/manifest.json` exists
- Ensure file permissions are correct (644 for files, 755 for directories)
- Clear Laravel cache: `php artisan cache:clear`

**Issue: CSS/JS not minified or optimized**
- Make sure you ran `npm run build` (not `npm run dev`)
- Check that `APP_ENV=production` in your `.env` file
- Verify the build files in `public/build/assets/` have hash names (e.g., `app-abc123.js`)

**Issue: "Vite manifest not found" error**
- Ensure `public/build/.vite/manifest.json` exists
- Check file permissions on the manifest file
- Rebuild assets: `npm run build` and re-upload

**Issue: Styles or scripts missing after deployment**
- Clear browser cache
- Verify `@vite(['resources/css/app.css', 'resources/js/app.js'])` is in your Blade templates
- Check that `APP_URL` in `.env` matches your domain

#### Updating Assets After Changes

Whenever you make changes to CSS or JavaScript:

1. **On your local machine:**
   ```bash
   npm run build
   ```

2. **Upload only the changed files** from `public/build/` to your server, or:
   - Upload the entire `public/build/` directory to replace old files

3. **Clear Laravel cache** (if needed):
   ```bash
   php artisan view:clear
   php artisan cache:clear
   ```

#### Production vs Development

| Environment | Command | What It Does |
|------------|---------|--------------|
| **Development** | `npm run dev` | Starts Vite dev server with hot reload (NOT for production) |
| **Production** | `npm run build` | Builds optimized, minified assets for production |

**Remember:** Never run `npm run dev` on your production server. Always build assets locally and upload the `public/build/` directory.

---

## Environment Configuration

### 1. Create `.env` File on Server

1. In cPanel File Manager, navigate to your application root
2. Create a new file named `.env`
3. Copy the contents from your local `.env.example` or create new:

```env
APP_NAME="E-PoE System"
APP_ENV=production
APP_KEY=
APP_DEBUG=false
APP_URL=https://yourdomain.com

LOG_CHANNEL=stack
LOG_LEVEL=error

# Database Configuration
DB_CONNECTION=pgsql
DB_HOST=localhost
DB_PORT=5432
DB_DATABASE=your_full_database_name
DB_USERNAME=your_full_username
DB_PASSWORD=your_secure_password

# Broadcasting (if needed)
BROADCAST_DRIVER=log
CACHE_DRIVER=file
FILESYSTEM_DISK=local
QUEUE_CONNECTION=sync
SESSION_DRIVER=file
SESSION_LIFETIME=120

# Mail Configuration (Update with your SMTP settings)
MAIL_MAILER=smtp
MAIL_HOST=mail.yourdomain.com
MAIL_PORT=587
MAIL_USERNAME=noreply@yourdomain.com
MAIL_PASSWORD=your_mail_password
MAIL_ENCRYPTION=tls
MAIL_FROM_ADDRESS=noreply@yourdomain.com
MAIL_FROM_NAME="${APP_NAME}"

# Redis Configuration (if available on TrueHost)
REDIS_HOST=127.0.0.1
REDIS_PASSWORD=null
REDIS_PORT=6379

# Google Analytics (if configured)
GA4_MEASUREMENT_ID=
GA4_API_SECRET=
GA4_ENABLED=false

# File Upload Settings
FILESYSTEM_DISK=public
```

### 2. Generate Application Key

If you have SSH access:

```bash
cd /home/username/public_html
php artisan key:generate
```

If you don't have SSH access, you can generate a key locally and add it to `.env`:

```bash
# On local machine
php artisan key:generate --show
```

Copy the generated key and add it to `APP_KEY=` in your server's `.env` file.

### 3. Update Database Connection

Verify your PostgreSQL connection details in `.env` match what you noted from cPanel.

---

## File Permissions

### 1. Set Directory Permissions

If you have SSH access:

```bash
cd /home/username/public_html

# Set storage and bootstrap/cache permissions
chmod -R 775 storage bootstrap/cache
chown -R username:username storage bootstrap/cache
```

If using cPanel File Manager:

1. Navigate to `storage/` directory
2. Right-click → **Change Permissions**
3. Set to **775** (or **755** if 775 doesn't work)
4. Check **Recurse into subdirectories**
5. Repeat for `bootstrap/cache/` directory

### 2. Create Required Directories

Ensure these directories exist and are writable:

```
storage/
├── app/
│   ├── public/
│   │   └── poe/          ← For file uploads
│   │       ├── assignments/
│   │       ├── practical-evidence/
│   │       └── submissions/
│   └── backups/          ← For database backups
├── framework/
│   ├── cache/
│   ├── sessions/
│   └── views/
└── logs/
```

Create these directories if they don't exist:

```bash
# Via SSH
mkdir -p storage/app/public/poe/assignments
mkdir -p storage/app/public/poe/practical-evidence
mkdir -p storage/app/public/poe/submissions
mkdir -p storage/app/backups
chmod -R 775 storage
```

---

## Database Migration

### 1. Run Migrations

If you have SSH access:

```bash
cd /home/username/public_html
php artisan migrate --force
```

**Note:** The `--force` flag is required in production.

If you don't have SSH access, you can:
- Use cPanel's **Terminal** feature (if available)
- Or run migrations via a custom admin route (temporary, remove after use)

### 2. Seed Initial Data (Optional)

If you have seeders for initial data:

```bash
php artisan db:seed --force
```

### 3. Create Storage Link

Link the storage directory for public file access:

```bash
php artisan storage:link
```

This creates a symbolic link from `public/storage` to `storage/app/public`.

---

## Application Optimization

### 1. Optimize Configuration

```bash
# Cache configuration
php artisan config:cache

# Cache routes
php artisan route:cache

# Cache views
php artisan view:cache

# Optimize autoloader
composer dump-autoload --optimize --classmap-authoritative
```

### 2. Enable OPcache (if available)

In your `php.ini` or via cPanel PHP settings:

```ini
opcache.enable=1
opcache.memory_consumption=128
opcache.interned_strings_buffer=8
opcache.max_accelerated_files=10000
opcache.revalidate_freq=2
```

### 3. Configure .htaccess

Ensure your root `.htaccess` file exists and contains:

```apache
<IfModule mod_rewrite.c>
    <IfModule mod_negotiation.c>
        Options -MultiViews -Indexes
    </IfModule>

    RewriteEngine On

    # Handle Authorization Header
    RewriteCond %{HTTP:Authorization} .
    RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]

    # Redirect Trailing Slashes If Not A Folder...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_URI} (.+)/$
    RewriteRule ^ %1 [L,R=301]

    # Send Requests To Front Controller...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteRule ^ index.php [L]
</IfModule>
```

And in `public/.htaccess`:

```apache
<IfModule mod_rewrite.c>
    <IfModule mod_negotiation.c>
        Options -MultiViews -Indexes
    </IfModule>

    RewriteEngine On

    # Handle Authorization Header
    RewriteCond %{HTTP:Authorization} .
    RewriteRule .* - [E=HTTP_AUTHORIZATION:%{HTTP:Authorization}]

    # Redirect Trailing Slashes If Not A Folder...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_URI} (.+)/$
    RewriteRule ^ %1 [L,R=301]

    # Send Requests To Front Controller...
    RewriteCond %{REQUEST_FILENAME} !-d
    RewriteCond %{REQUEST_FILENAME} !-f
    RewriteRule ^ index.php [L]
</IfModule>
```

---

## Security Configuration

### 1. Secure .env File

Ensure `.env` is not publicly accessible:

```apache
# In .htaccess
<Files .env>
    Order allow,deny
    Deny from all
</Files>
```

### 2. Disable Directory Listing

```apache
# In .htaccess
Options -Indexes
```

### 3. Set Secure Headers

Add to your `.htaccess`:

```apache
# Security Headers
<IfModule mod_headers.c>
    Header set X-Content-Type-Options "nosniff"
    Header set X-Frame-Options "SAMEORIGIN"
    Header set X-XSS-Protection "1; mode=block"
    Header set Referrer-Policy "strict-origin-when-cross-origin"
</IfModule>
```

### 4. Enable HTTPS

1. Install SSL certificate via cPanel (Let's Encrypt is free)
2. Force HTTPS redirect in `.htaccess`:

```apache
# Force HTTPS
RewriteCond %{HTTPS} off
RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
```

### 5. Update APP_URL

Ensure `APP_URL` in `.env` matches your domain with `https://`:

```env
APP_URL=https://yourdomain.com
```

---

## Troubleshooting

### Common Issues and Solutions

#### 1. "500 Internal Server Error"

**Causes:**
- Incorrect file permissions
- Missing `.env` file or incorrect configuration
- PHP version mismatch
- Missing PHP extensions

**Solutions:**
- Check error logs: `storage/logs/laravel.log`
- Verify file permissions (775 for storage, 755 for others)
- Ensure all required PHP extensions are enabled
- Check `.env` file exists and has correct values

#### 2. "Database Connection Failed"

**Causes:**
- Incorrect database credentials
- Wrong database host
- PostgreSQL not enabled

**Solutions:**
- Verify database credentials in `.env`
- Check PostgreSQL host (might not be `localhost`)
- Ensure PostgreSQL is enabled in cPanel
- Test connection using cPanel's PostgreSQL management tools

#### 3. "Storage Directory Not Writable"

**Causes:**
- Incorrect permissions
- Wrong ownership

**Solutions:**
```bash
chmod -R 775 storage bootstrap/cache
chown -R username:username storage bootstrap/cache
```

#### 4. "Route Not Found" or "404 Errors"

**Causes:**
- `.htaccess` not working
- `mod_rewrite` not enabled
- Incorrect document root

**Solutions:**
- Enable `mod_rewrite` in cPanel
- Verify `.htaccess` file exists
- Check document root points to `public/` directory
- Clear route cache: `php artisan route:clear`

#### 5. "Class Not Found" Errors

**Causes:**
- Autoloader not optimized
- Missing vendor files

**Solutions:**
```bash
composer dump-autoload --optimize
composer install --no-dev --optimize-autoloader
```

#### 6. "Session Storage Not Writable"

**Causes:**
- `storage/framework/sessions/` not writable

**Solutions:**
```bash
chmod -R 775 storage/framework/sessions
```

#### 7. PostgreSQL Connection Timeout

**Causes:**
- Firewall blocking connection
- Wrong port number

**Solutions:**
- Verify PostgreSQL port (usually 5432)
- Check if TrueHost requires specific connection settings
- Contact TrueHost support for PostgreSQL connection details

#### 8. Vite Assets Not Loading (CSS/JS Missing)

**Causes:**
- `public/build/` directory not uploaded
- Assets not built before deployment
- Incorrect file permissions
- Manifest file missing

**Solutions:**
1. **Verify assets were built:**
   ```bash
   # On local machine
   npm run build
   # Check that public/build/ directory exists with files
   ```

2. **Upload built assets:**
   - Ensure `public/build/` directory is uploaded to server
   - Verify `public/build/.vite/manifest.json` exists

3. **Check file permissions:**
   ```bash
   chmod -R 755 public/build
   ```

4. **Clear Laravel cache:**
   ```bash
   php artisan view:clear
   php artisan cache:clear
   ```

5. **Verify .env settings:**
   - Ensure `APP_ENV=production`
   - Check `APP_URL` matches your domain

#### 9. "Vite manifest not found" Error

**Causes:**
- `public/build/.vite/manifest.json` missing
- Assets not built
- Wrong directory structure

**Solutions:**
1. Build assets locally:
   ```bash
   npm run build
   ```

2. Verify manifest exists:
   - Check `public/build/.vite/manifest.json` on server
   - Ensure file permissions are correct (644)

3. Re-upload the entire `public/build/` directory

#### 10. Styles/JavaScript Not Working After Deployment

**Causes:**
- Browser cache
- Assets not minified
- Wrong build command used

**Solutions:**
1. **Clear browser cache** (Ctrl+F5 or Cmd+Shift+R)

2. **Verify production build:**
   - Check that files in `public/build/assets/` have hash names (e.g., `app-abc123.js`)
   - If files don't have hashes, you may have uploaded dev assets

3. **Rebuild and re-upload:**
   ```bash
   # On local machine
   npm run build  # NOT npm run dev
   # Upload public/build/ to server
   ```

4. **Check browser console** for 404 errors on asset files

### Viewing Error Logs

1. **Laravel Logs:**
   - Location: `storage/logs/laravel.log`
   - View via cPanel File Manager or FTP

2. **PHP Error Logs:**
   - Check cPanel → **Error Log** section
   - Or via File Manager: `public_html/error_log`

3. **Apache Error Logs:**
   - Check cPanel → **Metrics** → **Errors**

---

## Post-Deployment Checklist

### Initial Setup

- [ ] Application files uploaded successfully
- [ ] `.env` file created with correct configuration
- [ ] `APP_KEY` generated and set
- [ ] Database connection tested and working
- [ ] Migrations run successfully
- [ ] Storage directories created and writable
- [ ] Storage link created (`php artisan storage:link`)
- [ ] File permissions set correctly (775 for storage, 755 for others)

### Configuration

- [ ] `APP_ENV=production` set in `.env`
- [ ] `APP_DEBUG=false` set in `.env`
- [ ] `APP_URL` matches your domain with `https://`
- [ ] Database credentials correct
- [ ] Mail configuration updated (SMTP settings)
- [ ] Redis configured (if available)
- [ ] Google Analytics configured (if using)

### Optimization

- [ ] Vite assets built (`npm run build` on local machine)
- [ ] `public/build/` directory uploaded to server
- [ ] Configuration cached (`php artisan config:cache`)
- [ ] Routes cached (`php artisan route:cache`)
- [ ] Views cached (`php artisan view:cache`)
- [ ] Autoloader optimized (`composer dump-autoload --optimize`)

### Security

- [ ] SSL certificate installed and HTTPS enabled
- [ ] `.env` file secured (not publicly accessible)
- [ ] Directory listing disabled
- [ ] Security headers configured
- [ ] Strong database passwords set
- [ ] Admin accounts created with strong passwords

### Testing

- [ ] Homepage loads correctly
- [ ] CSS styles are applied correctly
- [ ] JavaScript functionality works (no console errors)
- [ ] User registration/login works
- [ ] Database operations work (create, read, update, delete)
- [ ] File uploads work (assignments, evidence, etc.)
- [ ] Email sending works (if configured)
- [ ] All user roles can access their portals
- [ ] Reports generate correctly
- [ ] PDF exports work

### Monitoring

- [ ] Error logging enabled and working
- [ ] Regular backups configured (if available)
- [ ] Performance monitoring set up
- [ ] Uptime monitoring configured (optional)

---

## Additional Notes

### TrueHost-Specific Considerations

1. **Document Root:**
   - TrueHost typically uses `public_html/` as document root
   - You may need to adjust Laravel's public directory structure
   - Or configure document root to point to `public/` subdirectory

2. **PostgreSQL Host:**
   - TrueHost may use a different hostname for PostgreSQL
   - Check cPanel for the exact connection string
   - It might be `localhost`, `127.0.0.1`, or a specific hostname

3. **PHP Version:**
   - Ensure you're using PHP 8.0+ for Laravel 9.x
   - Check via cPanel → **Select PHP Version**

4. **Cron Jobs:**
   - If you have scheduled tasks, set them up in cPanel → **Cron Jobs**
   - Example: `* * * * * cd /home/username/public_html && php artisan schedule:run >> /dev/null 2>&1`

5. **Backup Strategy:**
   - Use cPanel's backup feature for regular backups
   - Or implement automated backups via Laravel (stored in `storage/app/backups/`)

### Performance Tips

1. **Enable OPcache** for better PHP performance
2. **Use Redis** for caching if available on your plan
3. **Optimize images** before upload
4. **Enable Gzip compression** via `.htaccess`
5. **Use CDN** for static assets (optional)

### Support Resources

- **TrueHost Support:** Check your cPanel for support contact information
- **Laravel Documentation:** https://laravel.com/docs
- **PostgreSQL Documentation:** https://www.postgresql.org/docs/

---

## Quick Reference Commands

### Local Development (Before Deployment)

```bash
# Build Vite assets for production
npm install
npm run build

# Prepare PHP dependencies
composer install --optimize-autoloader --no-dev
composer dump-autoload --optimize
```

### On Production Server

```bash
# Clear all caches
php artisan cache:clear
php artisan config:clear
php artisan route:clear
php artisan view:clear

# Optimize for production
php artisan config:cache
php artisan route:cache
php artisan view:cache

# Run migrations
php artisan migrate --force

# Create storage link
php artisan storage:link

# Check application status
php artisan about
```

### Updating Assets After Changes

```bash
# On local machine
npm run build

# Then upload public/build/ directory to server
# And clear view cache on server
php artisan view:clear
```

---

## Conclusion

After completing all steps, your E-PoE system should be live on TrueHost with PostgreSQL. Regularly monitor logs, perform backups, and keep the application updated for security and performance.

For issues specific to TrueHost, contact their support team with your error logs and configuration details.

---

**Last Updated:** January 2026
**Version:** 1.0

