# .env File Configuration for Supabase

## Required Database Settings

Make sure your `.env` file has these **exact** lines (replace with your actual Supabase credentials):

```env
DB_CONNECTION=pgsql
DB_HOST=db.xxxxx.supabase.co
DB_PORT=5432
DB_DATABASE=postgres
DB_USERNAME=postgres
DB_PASSWORD=your-actual-password-here
DB_SSLMODE=require
```

## Important Notes

1. **DB_CONNECTION must be `pgsql`** (not `mysql`)
2. **DB_HOST** should be your Supabase host (format: `db.xxxxx.supabase.co`)
3. **DB_PORT** should be `5432` (PostgreSQL default)
4. **DB_DATABASE** is usually `postgres` for Supabase
5. **DB_USERNAME** is usually `postgres` for Supabase
6. **DB_PASSWORD** is your Supabase database password
7. **DB_SSLMODE** should be `require` for Supabase

## Example .env Section

```env
APP_NAME=EPOE
APP_ENV=local
APP_KEY=base64:your-app-key-here
APP_DEBUG=true
APP_URL=http://localhost:8000

LOG_CHANNEL=stack
LOG_DEPRECATIONS_CHANNEL=null
LOG_LEVEL=debug

# Database Configuration - SUPABASE
DB_CONNECTION=pgsql
DB_HOST=db.abcdefghijklmnop.supabase.co
DB_PORT=5432
DB_DATABASE=postgres
DB_USERNAME=postgres
DB_PASSWORD=YourSecurePassword123!
DB_SSLMODE=require
```

## After Updating .env

1. **Save the file**
2. **Clear Laravel cache:**
   ```bash
   php artisan config:clear
   php artisan cache:clear
   ```
3. **Test connection:**
   ```bash
   php artisan migrate:status
   ```

## Common Mistakes

❌ `DB_CONNECTION=mysql` (wrong - should be pgsql)  
❌ `DB_HOST=localhost` (wrong - should be your Supabase host)  
❌ `DB_PORT=3306` (wrong - should be 5432)  
❌ Forgetting to save the .env file  
❌ Typos in variable names (DB_CONNECTION not DB_CONNECT)

✅ `DB_CONNECTION=pgsql` (correct)  
✅ `DB_HOST=db.xxxxx.supabase.co` (correct)  
✅ `DB_PORT=5432` (correct)

