# Switching from Supabase to Local PostgreSQL

This guide will help you switch from Supabase (cloud PostgreSQL) to a local standalone PostgreSQL database for better performance testing.

## Prerequisites

1. **Install PostgreSQL** on your local machine if not already installed
   - Windows: Download from https://www.postgresql.org/download/windows/
   - Or use a package manager like Chocolatey: `choco install postgresql`

2. **Create a database** for your application:
   ```sql
   CREATE DATABASE poe_system;
   ```

3. **Create a user** (or use the default postgres user):
   ```sql
   CREATE USER poe_user WITH PASSWORD 'your_password';
   GRANT ALL PRIVILEGES ON DATABASE poe_system TO poe_user;
   ```

## Step 1: Update .env File

Update your `.env` file with local PostgreSQL connection details:

```env
DB_CONNECTION=pgsql
DB_HOST=127.0.0.1
DB_PORT=5432
DB_DATABASE=poe_system
DB_USERNAME=poe_user
DB_PASSWORD=your_password

DB_CONNECTION=pgsql
DB_HOST=127.0.0.1
DB_PORT=5432
DB_DATABASE=poe_system
DB_USERNAME=postgres
DB_PASSWORD=postgres

# Remove or comment out Supabase-specific settings
# DB_SSLMODE=require
# DATABASE_URL=postgresql://...
```

## Step 2: Export Data from Supabase (Optional)

If you want to migrate your existing data:

1. **Export from Supabase:**
   ```bash
   pg_dump -h aws-1-eu-central-1.pooler.supabase.com -p 6543 -U postgres -d your_database_name > supabase_backup.sql
   ```

2. **Import to Local PostgreSQL:**
   ```bash
   psql -h localhost -U poe_user -d poe_system < supabase_backup.sql
   ```

## Step 3: Run Migrations

If starting fresh or after importing:

```bash
php artisan migrate:fresh --seed
```

Or if you imported data:

```bash
php artisan migrate
```

## Step 4: Test Connection

```bash
php artisan tinker
```

Then run:
```php
DB::connection()->getPdo();
```

If successful, you'll see the PDO object. If there's an error, check your credentials.

## Step 5: Clear Caches

```bash
php artisan config:clear
php artisan cache:clear
php artisan route:clear
php artisan view:clear
```

## Performance Comparison

After switching, you should notice:
- **Faster query execution** (no network latency)
- **Lower latency** (local connection vs cloud)
- **No connection pooler overhead**
- **Better for development/testing**

## Reverting to Supabase

If you want to switch back to Supabase, simply update your `.env` file with Supabase credentials:

```env
DB_CONNECTION=pgsql
DB_HOST=aws-1-eu-central-1.pooler.supabase.com
DB_PORT=6543
DB_DATABASE=your_supabase_db
DB_USERNAME=postgres
DB_PASSWORD=your_supabase_password
DB_SSLMODE=require
```

## Troubleshooting

1. **Connection refused**: Make sure PostgreSQL service is running
   - Windows: Check Services (services.msc) for "postgresql-x64-XX"
   - Or run: `pg_ctl start`

2. **Authentication failed**: Check username/password in `.env`

3. **Database doesn't exist**: Create it using `createdb` or psql

4. **Permission denied**: Grant proper permissions to your user

