# Quick Setup Guide: Redis & GA4 Integration

## Prerequisites

1. **Redis Server** installed and running
2. **Google Analytics (GA4)** account with Measurement ID

## Step 1: Install Redis

### Windows
Download and install from: https://github.com/microsoftarchive/redis/releases

Or use WSL:
```bash
sudo apt-get install redis-server
sudo service redis-server start
```

### Linux
```bash
sudo apt-get install redis-server
sudo systemctl start redis
sudo systemctl enable redis
```

### macOS
```bash
brew install redis
brew services start redis
```

## Step 2: Configure Environment

Add to your `.env` file:

```env
# Redis Configuration
CACHE_DRIVER=redis
SESSION_DRIVER=redis
QUEUE_CONNECTION=redis

REDIS_HOST=127.0.0.1
REDIS_PASSWORD=null
REDIS_PORT=6379

# Google Analytics (GA4)
GA4_ENABLED=true
GA4_MEASUREMENT_ID=G-XXXXXXXXXX
```

**Note**: Replace `G-XXXXXXXXXX` with your actual GA4 Measurement ID from Google Analytics.

## Step 3: Install Dependencies

The Predis package has already been added to `composer.json`. Run:

```bash
composer install
```

Or if you need to update:

```bash
composer update predis/predis
```

## Step 4: Clear Configuration Cache

```bash
php artisan config:clear
php artisan cache:clear
```

## Step 5: Verify Installation

### Test Redis Connection

```bash
php artisan tinker
```

Then in tinker:
```php
Cache::put('test', 'Redis is working!', 60);
Cache::get('test'); // Should return "Redis is working!"
```

### Test GA4

1. Open your application in a browser
2. Open browser Developer Tools (F12)
3. Go to Network tab
4. Filter by "gtag" or "analytics"
5. You should see requests to `www.google-analytics.com`

## Step 6: Monitor Performance

### Check Redis Stats

```php
use App\Services\RedisCacheService;
RedisCacheService::getCacheStats();
```

### View Redis Keys

```bash
redis-cli
> KEYS epoe:*
> GET epoe:hod:dashboard:stats:1:term:5
```

## Troubleshooting

### Redis Connection Failed

1. Check if Redis is running: `redis-cli ping` (should return `PONG`)
2. Verify `REDIS_HOST` and `REDIS_PORT` in `.env`
3. Check firewall settings
4. For Windows, ensure Redis service is started

### GA4 Not Tracking

1. Verify `GA4_ENABLED=true` in `.env`
2. Check `GA4_MEASUREMENT_ID` is correct (starts with `G-`)
3. Clear browser cache and cookies
4. Check browser console for JavaScript errors
5. Verify in Google Analytics Real-Time reports

### Cache Not Working

1. Verify `CACHE_DRIVER=redis` in `.env`
2. Run `php artisan config:clear`
3. Check Redis is running: `redis-cli ping`
4. Verify Redis connection in tinker

## Next Steps

1. Monitor cache hit rates
2. Adjust TTL values in `RedisCacheService` if needed
3. Set up GA4 custom reports in Google Analytics
4. Configure Redis persistence if needed for production

## Production Considerations

1. **Redis Persistence**: Configure Redis to persist data to disk
2. **Redis Password**: Set `REDIS_PASSWORD` in production
3. **Redis Clustering**: For high availability, consider Redis Cluster
4. **Monitoring**: Set up Redis monitoring (e.g., RedisInsight)
5. **Backup**: Regular Redis backups for session data

