# Storage & Media – Avoid Broken Images/Files

Media (logos, favicons, uploads, PDFs) is stored under `storage/app/public`. The app serves it via the URL path `/storage/...`, which must point to that folder.

## 1. Create the storage link (required)

Run once per environment (local and each server, e.g. cPanel):

```bash
php artisan storage:link
```

This creates a symbolic link:

- **Link:** `public/storage`
- **Target:** `storage/app/public`

Without this link, all `asset('storage/...')` URLs return 404 and images/files appear broken.

**If you get:** `Call to undefined function symlink()` (common on cPanel / shared hosting), use the fallback command instead:

```bash
php artisan storage:link-safe
```

That command tries creating the link via the shell. If it still can’t, it prints instructions to create the link manually (e.g. cPanel File Manager → create Symbolic Link).

**After deployment:** Run one of the above on the server (e.g. via SSH or cPanel Terminal).

---

## 2. cPanel / shared hosting

If your host does not allow symlinks:

1. **Option A – Symlink (if allowed)**  
   Run `php artisan storage:link` in the app root on the server.

2. **Option B – No symlinks**  
   Some hosts block symlinks. Alternatives:
   - Copy or rsync `storage/app/public/*` into a web-accessible folder and use that as your “storage” URL (requires custom config).
   - Or use a disk with a public URL (e.g. S3) and set `FILESYSTEM_DISK=public` and the disk’s `url` in `config/filesystems.php` to that public base URL.

---

## 3. Correct `APP_URL`

In `.env` set `APP_URL` to the real site URL (e.g. `https://yourdomain.com`). Wrong `APP_URL` can break absolute URLs for assets and storage.

---

## 4. Permissions

Ensure the web server can read files under `storage/app/public`:

```bash
chmod -R 755 storage
chmod -R 755 bootstrap/cache
```

---

## Quick check

- Visit: `https://yourdomain.com/storage/`  
  You should get a 403 or directory listing, not 404. If 404, the storage link is missing or wrong.
- Upload a logo in Admin → Settings and reload the login page; it should display if the link exists and `APP_URL` is correct.
