# Quick Guide: Switch to Local PostgreSQL

## Quick Steps

### 1. Update `.env` file

Change these lines in your `.env` file:

**FROM (Supabase):**
```env
DB_HOST=aws-1-eu-central-1.pooler.supabase.com
DB_PORT=6543
DB_DATABASE=your_supabase_db
DB_USERNAME=postgres
DB_PASSWORD=your_supabase_password
DB_SSLMODE=require
```

**TO (Local PostgreSQL):**
```env
DB_HOST=127.0.0.1
DB_PORT=5432
DB_DATABASE=poe_system
DB_USERNAME=postgres
DB_PASSWORD=your_local_password
DB_SSLMODE=prefer
```

### 2. Make sure PostgreSQL is running locally

**Windows:**
- Check Services: Press `Win + R`, type `services.msc`, look for PostgreSQL service
- Or check if it's running: `sc query postgresql-x64-*`

**Start PostgreSQL if needed:**
```bash
# Using pg_ctl (adjust version number)
"C:\Program Files\PostgreSQL\15\bin\pg_ctl.exe" start -D "C:\Program Files\PostgreSQL\15\data"
```

### 3. Create database (if not exists)

```bash
# Using psql
psql -U postgres
CREATE DATABASE poe_system;
\q
```

### 4. Test connection

```bash
php artisan tinker
```

Then in tinker:
```php
DB::connection()->getPdo();
// Should return: PDO {#1234 ...}
```

### 5. Clear caches

```bash
php artisan config:clear
php artisan cache:clear
```

### 6. Run migrations (if starting fresh)

```bash
php artisan migrate:fresh --seed
```

## Expected Performance Improvements

- **Query Speed**: 10-50x faster (no network latency)
- **Connection Time**: Instant (local vs 50-200ms to Supabase)
- **Overall Page Load**: Should be noticeably faster

## To Switch Back to Supabase

Just revert the `.env` changes back to Supabase credentials.

