# Verify Supabase Hostname

## Current Issue

The hostname `db.kukjqcpinonfieksuomo.supabase.co` cannot be resolved. This could mean:

1. **Hostname is incorrect** - The most common issue
2. **Project is paused** - Supabase pauses inactive projects
3. **Network/DNS issue** - Your network cannot resolve Supabase domains

## How to Get the Correct Hostname

### Step 1: Go to Supabase Dashboard

1. Visit: https://app.supabase.com
2. Login to your account
3. Select your project

### Step 2: Get Connection Details

**Method 1: Connection String**
1. Go to **Settings** → **Database**
2. Scroll to **Connection string**
3. Look for the **URI** or **Connection pooling** section
4. Copy the hostname from the connection string

**Method 2: Connection Info**
1. Go to **Settings** → **Database**
2. Find **Connection info** section
3. Copy the **Host** value

### Step 3: Verify Hostname Format

Supabase hostnames typically look like:
- `db.xxxxxxxxxxxxx.supabase.co`
- `db.xxxxxxxxxxxxx.supabase.co` (with your project reference ID)

### Step 4: Check Project Status

1. In Supabase Dashboard, check if your project shows:
   - ✅ **Active** (green indicator)
   - ❌ **Paused** (if paused, you need to resume it)

### Step 5: Update .env File

Once you have the correct hostname, update your `.env`:

```env
DB_HOST=db.correct-hostname-here.supabase.co
```

Then:
```bash
php artisan config:clear
php artisan migrate:status
```

## Alternative: Use Connection Pooling

If direct connection doesn't work, try connection pooling:

1. In Supabase Dashboard → Settings → Database
2. Find **Connection pooling** section
3. Use the **Session mode** connection string
4. Update your `.env` with port `6543`:

```env
DB_HOST=db.xxxxx.supabase.co
DB_PORT=6543
```

## Quick Test

You can test if the hostname is correct by:

1. **Browser**: Try opening `https://db.xxxxx.supabase.co` (should show connection error, not "site not found")
2. **Command**: `ping db.xxxxx.supabase.co` (should resolve to an IP)

## Common Issues

- **Project paused**: Resume it in Supabase dashboard
- **Wrong project**: Make sure you're looking at the correct project
- **Hostname changed**: Supabase sometimes changes hostnames when projects are paused/resumed
- **Network restrictions**: Corporate firewall might block Supabase

## Next Steps

1. **Verify hostname** in Supabase dashboard
2. **Check project status** (must be Active)
3. **Update .env** with correct hostname
4. **Clear config cache**: `php artisan config:clear`
5. **Test connection**: `php artisan migrate:status`

