<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PoeEvidence extends Model
{
    use HasFactory;

    protected $fillable = [
        'poe_submission_id',
        'file_path',
        'file_type',
        'file_name',
        'original_name',
        'file_size',
        'mime_type',
        'tags',
        'description',
        'version',
    ];

    protected $casts = [
        'tags' => 'array',
        'file_size' => 'integer',
        'version' => 'integer',
    ];

    // Relationships
    public function poeSubmission()
    {
        return $this->belongsTo(PoeSubmission::class);
    }

    // Helper methods
    public function getFileSizeHumanAttribute()
    {
        $bytes = $this->file_size;
        $units = ['B', 'KB', 'MB', 'GB'];
        
        for ($i = 0; $bytes > 1024 && $i < count($units) - 1; $i++) {
            $bytes /= 1024;
        }
        
        return round($bytes, 2) . ' ' . $units[$i];
    }

    public function isDocument()
    {
        return $this->file_type === 'document';
    }

    public function isImage()
    {
        return $this->file_type === 'image';
    }

    public function isVideo()
    {
        return $this->file_type === 'video';
    }
}
