<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TermDepartmentUnit extends Model
{
    use HasFactory;

    protected $table = 'term_department_units';

    protected $fillable = [
        'term_id',
        'department_id',
        'level_id',
        'unit_id',
    ];

    // Relationships
    public function term()
    {
        return $this->belongsTo(Term::class);
    }

    public function department()
    {
        return $this->belongsTo(Department::class);
    }

    public function level()
    {
        return $this->belongsTo(Level::class);
    }

    public function unit()
    {
        return $this->belongsTo(Unit::class);
    }
}
