<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UnitValidation extends Model
{
    use HasFactory;

    protected $fillable = [
        'validation_request_id',
        'student_id',
        'decision',
        'original_marks',
        'adjusted_marks',
        'validator_comment',
        'validated_by',
        'validated_at',
    ];

    protected $casts = [
        'original_marks' => 'decimal:2',
        'adjusted_marks' => 'decimal:2',
        'validated_at' => 'datetime',
    ];

    // Relationships
    public function validationRequest()
    {
        return $this->belongsTo(ValidationRequest::class);
    }

    public function student()
    {
        return $this->belongsTo(User::class, 'student_id');
    }

    public function validator()
    {
        return $this->belongsTo(User::class, 'validated_by');
    }

    // Helper methods
    public function isPending()
    {
        return $this->decision === 'pending';
    }

    public function isApproved()
    {
        return $this->decision === 'approved';
    }

    public function isModified()
    {
        return $this->decision === 'modified';
    }

    public function isRejected()
    {
        return $this->decision === 'rejected';
    }

    public function getFinalMarks()
    {
        return $this->adjusted_marks ?? $this->original_marks;
    }
}
