<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Add indexes to users table
        Schema::table('users', function (Blueprint $table) {
            $table->index('role');
            $table->index('status');
            $table->index('department_id');
            $table->index(['role', 'status']); // Composite index for common queries
        });

        // Add indexes to terms table
        Schema::table('terms', function (Blueprint $table) {
            $table->index('status');
            $table->index('start_date');
            $table->index('end_date');
        });

        // Add indexes to poe_submissions table
        Schema::table('poe_submissions', function (Blueprint $table) {
            $table->index('status');
            $table->index('student_id');
            $table->index('unit_id');
            $table->index('class_id');
            $table->index(['status', 'student_id']); // Composite for filtering
        });

        // Add indexes to classes table
        Schema::table('classes', function (Blueprint $table) {
            $table->index('term_id');
            $table->index('department_id');
            $table->index('level_id');
        });

        // Add indexes to enrollments table
        Schema::table('enrollments', function (Blueprint $table) {
            $table->index('student_id');
            $table->index('class_id');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropIndex(['role']);
            $table->dropIndex(['status']);
            $table->dropIndex(['department_id']);
            $table->dropIndex(['role', 'status']);
        });

        Schema::table('terms', function (Blueprint $table) {
            $table->dropIndex(['status']);
            $table->dropIndex(['start_date']);
            $table->dropIndex(['end_date']);
        });

        Schema::table('poe_submissions', function (Blueprint $table) {
            $table->dropIndex(['status']);
            $table->dropIndex(['student_id']);
            $table->dropIndex(['unit_id']);
            $table->dropIndex(['class_id']);
            $table->dropIndex(['status', 'student_id']);
        });

        Schema::table('classes', function (Blueprint $table) {
            $table->dropIndex(['term_id']);
            $table->dropIndex(['department_id']);
            $table->dropIndex(['level_id']);
        });

        Schema::table('enrollments', function (Blueprint $table) {
            $table->dropIndex(['student_id']);
            $table->dropIndex(['class_id']);
            $table->dropIndex(['status']);
        });
    }
};
