<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        // Drop the existing check constraint if it exists
        DB::statement("ALTER TABLE assignments DROP CONSTRAINT IF EXISTS assignments_type_check");
        
        // Recreate the constraint with the correct values (practical instead of quiz)
        DB::statement("ALTER TABLE assignments ADD CONSTRAINT assignments_type_check CHECK (type IN ('assignment', 'exam', 'practical', 'project'))");
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        // Revert back to include quiz
        DB::statement("ALTER TABLE assignments DROP CONSTRAINT IF EXISTS assignments_type_check");
        DB::statement("ALTER TABLE assignments ADD CONSTRAINT assignments_type_check CHECK (type IN ('assignment', 'exam', 'quiz', 'project'))");
    }
};
