<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('practical_evidence_comments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('practical_evidence_id')->constrained('practical_evidences')->onDelete('cascade');
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->enum('role', ['trainer', 'verifier', 'hod'])->default('trainer');
            $table->text('comment');
            $table->timestamps();
            
            $table->index(['practical_evidence_id', 'role']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('practical_evidence_comments');
    }
};
