<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('practical_evidence_comments', function (Blueprint $table) {
            // Check if column doesn't exist before adding
            if (!Schema::hasColumn('practical_evidence_comments', 'practical_evidence_id')) {
                $table->foreignId('practical_evidence_id')->nullable()->after('id')->constrained('practical_evidences')->onDelete('cascade');
            }
        });

        // If task_id exists and has data, we might need to migrate it
        // But for now, we'll just add the column and let it be nullable initially
        // You can populate it manually if needed
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('practical_evidence_comments', function (Blueprint $table) {
            if (Schema::hasColumn('practical_evidence_comments', 'practical_evidence_id')) {
                $table->dropForeign(['practical_evidence_id']);
                $table->dropColumn('practical_evidence_id');
            }
        });
    }
};
