<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Create assessor_sections first (in same migration so order is guaranteed)
        if (!Schema::hasTable('assessor_sections')) {
            Schema::create('assessor_sections', function (Blueprint $table) {
                $table->id();
                $table->string('name');
                $table->unsignedInteger('order')->default(0);
                $table->timestamps();
            });
        }

        Schema::create('assessor_criteria', function (Blueprint $table) {
            $table->id();
            $table->foreignId('section_id')->constrained('assessor_sections')->onDelete('cascade');
            $table->text('description');
            $table->integer('marks_available');
            $table->unsignedInteger('order')->default(0);
            $table->timestamps();

            $table->index('section_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('assessor_criteria');
        Schema::dropIfExists('assessor_sections');
    }
};
