@extends('layouts.admin')

@section('title', 'Department Report')
@section('page-title', 'Department Report')

@section('content')
    <div class="bg-white rounded-lg shadow-sm p-8">
        <x-report-header 
            :institution="$institution" 
            title="Department Portfolio Report"
            :subtitle="$department->name . ($term ? ' - ' . $term->name : '')"
        />

        <!-- Department Information -->
        <div class="mb-6 bg-gray-50 p-4 rounded-lg">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <p class="text-sm font-medium text-gray-600">Department</p>
                    <p class="text-lg font-semibold text-gray-900">{{ $department->name }}</p>
                </div>
                <div>
                    <p class="text-sm font-medium text-gray-600">Code</p>
                    <p class="text-lg font-semibold text-gray-900">{{ $department->code }}</p>
                </div>
                @if($term)
                    <div>
                        <p class="text-sm font-medium text-gray-600">Term</p>
                        <p class="text-lg font-semibold text-gray-900">{{ $term->name }}</p>
                    </div>
                @endif
            </div>
        </div>

        <!-- Summary Statistics -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
            <div class="bg-blue-50 p-4 rounded-lg">
                <p class="text-sm font-medium text-blue-600">Total Students</p>
                <p class="text-2xl font-bold text-blue-900 mt-1">{{ $stats['total_students'] }}</p>
            </div>
            <div class="bg-green-50 p-4 rounded-lg">
                <p class="text-sm font-medium text-green-600">Total Classes</p>
                <p class="text-2xl font-bold text-green-900 mt-1">{{ $stats['total_classes'] }}</p>
            </div>
            <div class="bg-purple-50 p-4 rounded-lg">
                <p class="text-sm font-medium text-purple-600">Total Submissions</p>
                <p class="text-2xl font-bold text-purple-900 mt-1">{{ $stats['total_submissions'] }}</p>
            </div>
            <div class="bg-indigo-50 p-4 rounded-lg">
                <p class="text-sm font-medium text-indigo-600">Approved</p>
                <p class="text-2xl font-bold text-indigo-900 mt-1">{{ $stats['approved_submissions'] }}</p>
            </div>
        </div>

        <!-- Classes Overview -->
        @if($classes->count() > 0)
            <div class="mb-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Classes ({{ $classes->count() }})</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    @foreach($classes as $classItem)
                        <div class="bg-gray-50 p-4 rounded-lg">
                            <p class="font-semibold text-gray-900">{{ $classItem->name }}</p>
                            <p class="text-sm text-gray-600 mt-1">{{ $classItem->level->name }} | {{ $classItem->term->name }}</p>
                            @php
                                $classSubmissions = $submissions->where('class_id', $classItem->id);
                            @endphp
                            <p class="text-xs text-gray-500 mt-2">
                                {{ $classSubmissions->count() }} submission(s) | 
                                {{ $classSubmissions->where('status', 'validator_approved')->count() }} approved
                            </p>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif

        <!-- Submissions Summary -->
        @if($submissions->count() > 0)
            <div class="mb-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Submissions Summary</h3>
                <div class="overflow-x-auto">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Student</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Class</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Unit</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Submitted</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach($submissions->take(50) as $submission)
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm font-medium text-gray-900">{{ $submission->student->name }}</div>
                                        <div class="text-sm text-gray-500">{{ $submission->student->email }}</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        {{ $submission->schoolClass->name }}
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <div class="text-sm font-medium text-gray-900">{{ $submission->unit->code }}</div>
                                        <div class="text-sm text-gray-500">{{ $submission->unit->name }}</div>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $submission->getStatusBadgeClasses() }}">
                                            {{ $submission->getStatusLabel() }}
                                        </span>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        @if($submission->submitted_at)
                                            {{ $submission->submitted_at->format('M d, Y') }}
                                        @else
                                            <span class="text-gray-400">Not submitted</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                    @if($submissions->count() > 50)
                        <div class="bg-gray-50 px-6 py-3 text-sm text-gray-600">
                            Showing first 50 of {{ $submissions->count() }} submissions. Use filters to narrow down results.
                        </div>
                    @endif
                </div>
            </div>
        @else
            <div class="text-center py-12">
                <p class="text-gray-500">No submissions found for this department.</p>
            </div>
        @endif

        <x-report-footer :institution="$institution" />
    </div>

    @if(request('format') !== 'pdf')
        <div class="mt-6 flex gap-4">
            <a href="{{ route('admin.reports.department', array_merge(['department' => $department->id], request()->all(), ['format' => 'pdf'])) }}" 
               class="px-4 py-2 bg-red-600 text-white rounded-md hover:bg-red-700">
                Export as PDF
            </a>
            <a href="{{ route('admin.reports.department', array_merge(['department' => $department->id], request()->all(), ['format' => 'excel'])) }}" 
               class="px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700">
                Export as Excel
            </a>
            <a href="{{ route('admin.reports.index') }}" 
               class="px-4 py-2 bg-gray-200 text-gray-700 rounded-md hover:bg-gray-300">
                Back to Reports
            </a>
        </div>
    @endif
@endsection

