@php
use App\Services\GoogleAnalyticsService;
@endphp

@if(GoogleAnalyticsService::isEnabled())
    {!! GoogleAnalyticsService::getInitScript() !!}
    
    @if(isset($ga4PageView))
        <script>
            {!! GoogleAnalyticsService::trackPageView(
                $ga4PageView['title'] ?? 'Page',
                $ga4PageView['path'] ?? request()->path(),
                $ga4PageView['role'] ?? auth()->user()->role ?? null
            ) !!}
        </script>
    @endif

    @if(isset($ga4Event))
        <script>
            {!! GoogleAnalyticsService::trackEvent(
                $ga4Event['name'],
                $ga4Event['params'] ?? []
            ) !!}
        </script>
    @endif
@endif

