@props(['institution', 'title' => 'Report', 'subtitle' => ''])

<div class="report-header mb-6 border-b-2 border-gray-300 pb-4">
    <div class="flex justify-between items-start">
        <div class="flex-1">
            @if($institution['logo'])
                <img src="{{ asset('storage/' . $institution['logo']) }}" alt="{{ $institution['name'] }}" class="h-16 mb-2">
            @endif
            <h1 class="text-2xl font-bold text-gray-900">{{ $institution['name'] }}</h1>
            @if($institution['address'])
                <p class="text-sm text-gray-600 mt-1">{{ $institution['address'] }}</p>
            @endif
            @if($institution['phone'] || $institution['email'])
                <div class="flex gap-4 mt-1 text-sm text-gray-600">
                    @if($institution['phone'])
                        <span>Tel: {{ $institution['phone'] }}</span>
                    @endif
                    @if($institution['email'])
                        <span>Email: {{ $institution['email'] }}</span>
                    @endif
                </div>
            @endif
            @if($institution['website'])
                <p class="text-sm text-gray-600 mt-1">Website: {{ $institution['website'] }}</p>
            @endif
        </div>
        <div class="text-right">
            <h2 class="text-xl font-semibold text-gray-900">{{ $title }}</h2>
            @if($subtitle)
                <p class="text-sm text-gray-600 mt-1">{{ $subtitle }}</p>
            @endif
            <p class="text-xs text-gray-500 mt-2">Generated: {{ now()->format('F d, Y h:i A') }}</p>
        </div>
    </div>
</div>

