@extends('layouts.hod')

@section('title', 'Submission Details')
@section('page-title', 'Portfolio Submission Details')

@section('content')
<div class="mb-6">
    <a href="{{ route('hod.approvals.index') }}" class="text-purple-600 hover:text-purple-900 flex items-center">
        <svg class="h-5 w-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
        </svg>
        Back to Approvals
    </a>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
    <!-- Main Content -->
    <div class="lg:col-span-2 space-y-6">
        <!-- Submission Info -->
        <div class="bg-white shadow-sm rounded-lg overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                <h3 class="text-lg font-semibold text-gray-900">Submission Information</h3>
            </div>
            <div class="px-6 py-4">
                <dl class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Student</dt>
                        <dd class="mt-1 text-sm text-gray-900">
                            <div class="flex items-center">
                                <div class="h-8 w-8 rounded-full bg-purple-600 flex items-center justify-center mr-2">
                                    <span class="text-white font-semibold text-xs">{{ substr($submission->student->name, 0, 1) }}</span>
                                </div>
                                <div>
                                    <div class="font-medium">{{ $submission->student->name }}</div>
                                    <div class="text-xs text-gray-500">{{ $submission->student->email }}</div>
                                </div>
                            </div>
                        </dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Unit</dt>
                        <dd class="mt-1 text-sm text-gray-900">
                            <div class="font-medium">{{ $submission->unit->code }}</div>
                            <div class="text-xs text-gray-500">{{ $submission->unit->name }}</div>
                        </dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Class</dt>
                        <dd class="mt-1 text-sm text-gray-900">
                            <div class="font-medium">{{ $submission->schoolClass->name }}</div>
                            <div class="text-xs text-gray-500">{{ $submission->schoolClass->code }}</div>
                        </dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Status</dt>
                        <dd class="mt-1">
                            <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $submission->getStatusBadgeClasses() }}">
                                {{ ucfirst(str_replace('_', ' ', $submission->status)) }}
                            </span>
                        </dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Submitted</dt>
                        <dd class="mt-1 text-sm text-gray-900">
                            {{ $submission->submitted_at ? $submission->submitted_at->format('M d, Y H:i') : 'Not submitted' }}
                        </dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Version</dt>
                        <dd class="mt-1 text-sm text-gray-900">v{{ $submission->version }}</dd>
                    </div>
                </dl>
            </div>
        </div>

        <!-- Evidence Files -->
        <div class="bg-white shadow-sm rounded-lg overflow-hidden">
            <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                <h3 class="text-lg font-semibold text-gray-900">Evidence Files ({{ $submission->evidence->count() }})</h3>
            </div>
            <div class="px-6 py-4">
                @if($submission->evidence->count() > 0)
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        @foreach($submission->evidence as $evidence)
                            <div class="border border-gray-200 rounded-lg p-4 hover:bg-gray-50">
                                <div class="flex items-center justify-between">
                                    <div class="flex items-center space-x-3">
                                        <div class="flex-shrink-0">
                                            @if(in_array(strtolower($evidence->file_type), ['jpg', 'jpeg', 'png', 'gif']))
                                                <svg class="h-8 w-8 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                                </svg>
                                            @else
                                                <svg class="h-8 w-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                                </svg>
                                            @endif
                                        </div>
                                        <div class="flex-1 min-w-0">
                                            <p class="text-sm font-medium text-gray-900 truncate">{{ $evidence->file_name }}</p>
                                            <p class="text-xs text-gray-500">{{ $evidence->file_type }} • {{ number_format($evidence->file_size / 1024, 2) }} KB</p>
                                        </div>
                                    </div>
                                    <a href="{{ route('hod.submissions.evidence.download', $evidence) }}" 
                                       class="ml-4 text-purple-600 hover:text-purple-900">
                                        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                        </svg>
                                    </a>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <p class="text-sm text-gray-500">No evidence files uploaded.</p>
                @endif
            </div>
        </div>

        <!-- Reviews -->
        @if($submission->reviews->count() > 0)
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">Trainer Reviews</h3>
                </div>
                <div class="px-6 py-4 space-y-4">
                    @foreach($submission->reviews as $review)
                        <div class="border-l-4 border-blue-500 pl-4">
                            <div class="flex items-center justify-between mb-2">
                                <div class="flex items-center">
                                    <div class="h-8 w-8 rounded-full bg-blue-600 flex items-center justify-center mr-2">
                                        <span class="text-white font-semibold text-xs">{{ substr($review->reviewer->name, 0, 1) }}</span>
                                    </div>
                                    <div>
                                        <div class="text-sm font-medium text-gray-900">{{ $review->reviewer->name }}</div>
                                        <div class="text-xs text-gray-500">{{ $review->reviewed_at ? $review->reviewed_at->format('M d, Y H:i') : 'Not reviewed' }}</div>
                                    </div>
                                </div>
                                @if($review->marks)
                                    <div class="text-lg font-bold text-blue-600">{{ $review->marks }}%</div>
                                @endif
                            </div>
                            @if($review->feedback)
                                <p class="text-sm text-gray-700 mt-2">{{ $review->feedback }}</p>
                            @endif
                        </div>
                    @endforeach
                </div>
            </div>
        @endif
    </div>

    <!-- Sidebar -->
    <div class="space-y-6">
        <!-- Approval Actions -->
        @if($submission->status === 'trainer_reviewed')
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">Actions</h3>
                </div>
                <div class="px-6 py-4 space-y-4">
                    <!-- Approve Form -->
                    <form action="{{ route('hod.approvals.approve', $submission) }}" method="POST">
                        @csrf
                        <div class="mb-4">
                            <label for="approve_comments" class="block text-sm font-medium text-gray-700 mb-2">Comments (Optional)</label>
                            <textarea name="comments" id="approve_comments" rows="3" 
                                      class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500"
                                      placeholder="Add any comments..."></textarea>
                        </div>
                        <button type="submit" 
                                class="w-full bg-green-600 text-white px-4 py-2 rounded-md hover:bg-green-700 font-medium">
                            ✓ Approve Submission
                        </button>
                    </form>

                    <!-- Reject Form -->
                    <form action="{{ route('hod.approvals.reject', $submission) }}" method="POST">
                        @csrf
                        <div class="mb-4">
                            <label for="reject_comments" class="block text-sm font-medium text-gray-700 mb-2">Rejection Reason <span class="text-red-500">*</span></label>
                            <textarea name="comments" id="reject_comments" rows="3" required
                                      class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500"
                                      placeholder="Please provide a reason for rejection..."></textarea>
                        </div>
                        <button type="submit" 
                                onclick="return confirm('Are you sure you want to reject this submission?')"
                                class="w-full bg-red-600 text-white px-4 py-2 rounded-md hover:bg-red-700 font-medium">
                            ✗ Reject Submission
                        </button>
                    </form>
                </div>
            </div>
        @else
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">Status</h3>
                </div>
                <div class="px-6 py-4">
                    <p class="text-sm text-gray-600">
                        This submission has been {{ str_replace('_', ' ', $submission->status) }}.
                    </p>
                </div>
            </div>
        @endif

        <!-- Validation History -->
        @if($submission->validation)
            <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                    <h3 class="text-lg font-semibold text-gray-900">Validation</h3>
                </div>
                <div class="px-6 py-4">
                    <div class="flex items-center justify-between mb-2">
                        <span class="text-sm font-medium text-gray-900">{{ $submission->validation->validator->name }}</span>
                        <span class="px-2 py-1 text-xs font-semibold rounded-full {{ $submission->validation->status === 'approved' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                            {{ ucfirst($submission->validation->status) }}
                        </span>
                    </div>
                    @if($submission->validation->comments)
                        <p class="text-sm text-gray-700 mt-2">{{ $submission->validation->comments }}</p>
                    @endif
                    <p class="text-xs text-gray-500 mt-2">{{ $submission->validation->validated_at ? $submission->validation->validated_at->format('M d, Y H:i') : '' }}</p>
                </div>
            </div>
        @endif
    </div>
</div>
@endsection

