@extends('layouts.hod')

@section('title', 'Edit Assignment')
@section('page-title', 'Edit Assignment')

@section('content')
<div class="max-w-4xl mx-auto">
    <div class="mb-6">
        <a href="{{ request('context') === 'departmental' ? route('hod.units.show', [$assignment->unit, 'context' => 'departmental']) : route('hod.units.show', $assignment->unit) }}" class="text-purple-600 hover:text-purple-900 flex items-center mb-4">
            <svg class="h-5 w-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
            Back to Unit
        </a>
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Edit Assignment</h1>
                <p class="mt-1 text-sm text-gray-500">Unit: {{ $assignment->unit->name }} ({{ $assignment->unit->code }})</p>
            </div>
            <a href="{{ route('hod.assignments.show', $assignment) }}" 
               class="inline-flex items-center px-4 py-2 bg-gray-200 text-gray-700 text-sm font-medium rounded-md hover:bg-gray-300">
                <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 19l-7-7m0 0l7-7m-7 7h18"></path>
                </svg>
                Cancel
            </a>
        </div>
    </div>

    <form action="{{ route('hod.assignments.update', $assignment) }}" method="POST" enctype="multipart/form-data" class="bg-white rounded-lg shadow p-6">
        @csrf
        @method('PUT')
        
        <div class="space-y-6">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Title *</label>
                <input type="text" name="title" value="{{ old('title', $assignment->title) }}" required 
                       class="block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                @error('title')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>
            
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Type *</label>
                <select name="type" id="assignment_type" required 
                        class="block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500" 
                        onchange="togglePracticalFields()">
                    <option value="assignment" {{ $assignment->type === 'assignment' ? 'selected' : '' }}>Assignment</option>
                    <option value="exam" {{ $assignment->type === 'exam' ? 'selected' : '' }}>Exam</option>
                    <option value="practical" {{ $assignment->type === 'practical' ? 'selected' : '' }}>Practical</option>
                    <option value="project" {{ $assignment->type === 'project' ? 'selected' : '' }}>Project</option>
                </select>
                @error('type')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>
            
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Description</label>
                <textarea name="description" rows="3" 
                          class="block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">{{ old('description', $assignment->description) }}</textarea>
                @error('description')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>
            
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Total Marks</label>
                    <input type="number" name="total_marks" value="{{ old('total_marks', $assignment->total_marks) }}" min="0" 
                           class="block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                    @error('total_marks')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Due Date</label>
                    <input type="datetime-local" name="due_date" 
                           value="{{ old('due_date', $assignment->due_date ? $assignment->due_date->format('Y-m-d\TH:i') : '') }}" 
                           class="block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                    @error('due_date')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>
            </div>
            
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Start Date</label>
                <input type="datetime-local" name="start_date" 
                       value="{{ old('start_date', $assignment->start_date ? $assignment->start_date->format('Y-m-d\TH:i') : '') }}" 
                       class="block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                @error('start_date')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>
            
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Instructions</label>
                <textarea name="instructions" rows="4" 
                          class="block w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">{{ old('instructions', $assignment->instructions) }}</textarea>
                @error('instructions')
                    <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                @enderror
            </div>
            
            <div id="regular_attachments" class="{{ $assignment->type === 'practical' ? 'hidden' : '' }}">
                <label class="block text-sm font-medium text-gray-700 mb-2">Attachments</label>
                @if($assignment->attachments && count($assignment->attachments) > 0)
                    <div class="mb-2 space-y-2">
                        @foreach($assignment->attachments as $index => $attachment)
                            <div class="flex items-center justify-between p-2 bg-gray-50 rounded">
                                <span class="text-sm text-gray-700">{{ basename($attachment) }}</span>
                                <span class="text-xs text-gray-500">Existing file</span>
                            </div>
                        @endforeach
                    </div>
                @endif
                <input type="file" name="attachments[]" multiple 
                       class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-purple-50 file:text-purple-700 hover:file:bg-purple-100">
                <p class="mt-1 text-xs text-gray-500">You can select multiple files (max 10MB each). New files will replace existing ones.</p>
            </div>

            <div id="practical_tools" class="space-y-4 {{ $assignment->type !== 'practical' ? 'hidden' : '' }}">
                <div class="p-4 bg-purple-50 border border-purple-200 rounded-lg">
                    <p class="text-sm font-medium text-purple-900 mb-3">Practical Assessment Tools</p>
                    
                    <div class="space-y-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Candidate Tool</label>
                            @if($assignment->candidate_tool && count($assignment->candidate_tool) > 0)
                                <div class="mb-2 space-y-2">
                                    @foreach($assignment->candidate_tool as $index => $tool)
                                        <div class="flex items-center justify-between p-2 bg-white rounded">
                                            <span class="text-sm text-gray-700">{{ basename($tool) }}</span>
                                            <span class="text-xs text-gray-500">Existing file</span>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                            <input type="file" name="candidate_tool[]" multiple 
                                   class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-purple-50 file:text-purple-700 hover:file:bg-purple-100">
                            <p class="mt-2 text-xs text-gray-600">New files will replace existing ones.</p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-2">Assessor Tool</label>
                            @if($assignment->assessor_tool && count($assignment->assessor_tool) > 0)
                                <div class="mb-2 space-y-2">
                                    @foreach($assignment->assessor_tool as $index => $tool)
                                        <div class="flex items-center justify-between p-2 bg-white rounded">
                                            <span class="text-sm text-gray-700">{{ basename($tool) }}</span>
                                            <span class="text-xs text-gray-500">Existing file</span>
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                            <input type="file" name="assessor_tool[]" multiple 
                                   class="block w-full text-sm text-gray-500 file:mr-4 file:py-2 file:px-4 file:rounded-full file:border-0 file:text-sm file:font-semibold file:bg-purple-50 file:text-purple-700 hover:file:bg-purple-100">
                            <p class="mt-2 text-xs text-gray-600">New files will replace existing ones.</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="flex items-center">
                <input type="checkbox" name="is_published" value="1" id="is_published" 
                       {{ old('is_published', $assignment->is_published) ? 'checked' : '' }}
                       class="h-4 w-4 text-purple-600 focus:ring-purple-500 border-gray-300 rounded">
                <label for="is_published" class="ml-2 block text-sm text-gray-900">Publish (visible to students)</label>
            </div>
        </div>
        
        <div class="mt-6 flex justify-end gap-3">
            <a href="{{ route('hod.assignments.show', $assignment) }}" 
               class="px-4 py-2 bg-gray-200 text-gray-800 rounded-md hover:bg-gray-300">
                Cancel
            </a>
            <button type="submit" class="px-4 py-2 bg-purple-600 text-white rounded-md hover:bg-purple-700">
                Update Assignment
            </button>
        </div>
    </form>
</div>

@push('scripts')
<script>
function togglePracticalFields() {
    const assignmentType = document.getElementById('assignment_type').value;
    const regularAttachments = document.getElementById('regular_attachments');
    const practicalTools = document.getElementById('practical_tools');
    
    if (assignmentType === 'practical') {
        regularAttachments.classList.add('hidden');
        practicalTools.classList.remove('hidden');
    } else {
        regularAttachments.classList.remove('hidden');
        practicalTools.classList.add('hidden');
    }
}

document.addEventListener('DOMContentLoaded', function() {
    togglePracticalFields();
});
</script>
@endpush
@endsection
