@extends('layouts.hod')

@section('title', 'Term Submissions')
@section('page-title', 'Term Submissions - History')

@section('content')
    <div class="mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900">Submissions - {{ $term->name }}</h1>
                <p class="mt-1 text-sm text-gray-600">View all submissions from this historical term (Department only)</p>
            </div>
            <a href="{{ route('hod.history.show', $term) }}" class="text-purple-600 hover:text-purple-900">Back to Term Details</a>
        </div>
    </div>

    <!-- Filters -->
    <div class="bg-white shadow rounded-lg mb-6 p-4">
        <form method="GET" class="grid grid-cols-1 md:grid-cols-3 gap-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                <select name="status" class="w-full rounded-md border-gray-300">
                    <option value="">All</option>
                    <option value="submitted" {{ request('status') == 'submitted' ? 'selected' : '' }}>Submitted</option>
                    <option value="trainer_reviewed" {{ request('status') == 'trainer_reviewed' ? 'selected' : '' }}>Trainer Reviewed</option>
                    <option value="validator_approved" {{ request('status') == 'validator_approved' ? 'selected' : '' }}>Approved</option>
                </select>
            </div>
            @if($units->count() > 0)
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Unit</label>
                <select name="unit" class="w-full rounded-md border-gray-300">
                    <option value="">All Units</option>
                    @foreach($units as $unit)
                        <option value="{{ $unit->id }}" {{ request('unit') == $unit->id ? 'selected' : '' }}>{{ $unit->name }}</option>
                    @endforeach
                </select>
            </div>
            @endif
            @if(isset($classes) && $classes->count() > 0)
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-1">Class</label>
                <select name="class" class="w-full rounded-md border-gray-300">
                    <option value="">All Classes</option>
                    @foreach($classes as $class)
                        <option value="{{ $class->id }}" {{ request('class') == $class->id ? 'selected' : '' }}>{{ $class->name }}</option>
                    @endforeach
                </select>
            </div>
            @endif
            <div class="flex items-end">
                <button type="submit" class="w-full px-4 py-2 bg-purple-600 text-white rounded-md hover:bg-purple-700">Filter</button>
            </div>
        </form>
    </div>

    @if($submissions->isEmpty())
        <div class="bg-white shadow rounded-lg p-8 text-center">
            <h3 class="text-sm font-medium text-gray-900">No Submissions</h3>
            <p class="mt-1 text-sm text-gray-500">No submissions found for this term in your department.</p>
        </div>
    @else
        <div class="bg-white shadow rounded-lg overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Student</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Unit</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Class</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Submitted</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach($submissions as $submission)
                            <tr>
                                <td class="px-6 py-4 text-sm text-gray-900">{{ $submission->student->name ?? '-' }}</td>
                                <td class="px-6 py-4 text-sm text-gray-600">{{ $submission->unit->name ?? '-' }}</td>
                                <td class="px-6 py-4 text-sm text-gray-600">{{ $submission->schoolClass->name ?? '-' }}</td>
                                <td class="px-6 py-4 text-sm">
                                    <span class="px-2 py-1 text-xs rounded-full bg-gray-100 text-gray-800">{{ $submission->status }}</span>
                                </td>
                                <td class="px-6 py-4 text-sm text-gray-600">{{ $submission->created_at->format('M d, Y') }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="px-6 py-4 border-t">
                {{ $submissions->links() }}
            </div>
        </div>
    @endif
@endsection

