@extends('layouts.hod')

@section('title', 'View Message')
@section('page-title', 'View Message')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <div class="flex items-center justify-between">
            <a href="{{ route('hod.messages.index') }}" class="text-purple-600 hover:text-purple-800 font-medium flex items-center">
                <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                </svg>
                Back to Messages
            </a>
        </div>
    </div>

    <!-- Message Details -->
    <div class="bg-white rounded-xl shadow-md overflow-hidden">
        <div class="px-6 py-4 bg-gray-50 border-b border-gray-200">
            <h2 class="text-lg font-semibold text-gray-900">{{ $message->subject ?? 'No Subject' }}</h2>
        </div>
        <div class="p-6">
            <div class="flex items-start gap-4 mb-6">
                <div class="h-12 w-12 rounded-full bg-purple-100 flex items-center justify-center">
                    <span class="text-purple-600 font-semibold">
                        {{ substr($message->sender_id === auth()->id() ? $message->receiver->name : $message->sender->name, 0, 1) }}
                    </span>
                </div>
                <div class="flex-1">
                    <div class="flex items-center justify-between">
                        <div>
                            <p class="text-sm font-semibold text-gray-900">
                                {{ $message->sender_id === auth()->id() ? 'To: ' . $message->receiver->name : 'From: ' . $message->sender->name }}
                            </p>
                            <p class="text-xs text-gray-500">{{ $message->sender->email ?? $message->receiver->email }}</p>
                        </div>
                        <p class="text-xs text-gray-500">{{ $message->created_at->format('M d, Y h:i A') }}</p>
                    </div>
                </div>
            </div>
            <div class="prose max-w-none">
                <p class="text-gray-700 whitespace-pre-wrap">{{ $message->message ?? 'No message content.' }}</p>
            </div>
        </div>
    </div>
</div>
@endsection

