@extends('layouts.hod')

@section('title', 'Reports')
@section('page-title', 'Reports')

@section('content')
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <h1 class="text-2xl font-bold text-gray-900 mb-2">Department Reports</h1>
        <p class="text-gray-600">Generate and view reports for your department</p>
    </div>

    @if(!$activeTerm)
        <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4 rounded-lg">
            <p class="text-yellow-800 font-medium">No active term found. Please contact your administrator.</p>
        </div>
    @else
        <!-- Report Options -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Department Report -->
            <a href="{{ route('hod.reports.department') }}" 
               class="bg-white rounded-xl shadow-md hover:shadow-xl transition-all duration-300 p-6 border border-gray-200 hover:border-purple-300 group">
                <div class="flex items-center justify-between mb-4">
                    <div class="h-12 w-12 bg-purple-100 rounded-lg flex items-center justify-center group-hover:bg-purple-200 transition-colors">
                        <svg class="w-6 h-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                        </svg>
                    </div>
                    <svg class="w-5 h-5 text-gray-400 group-hover:text-purple-600 transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                    </svg>
                </div>
                <h3 class="text-lg font-semibold text-gray-900 mb-2">Department Report</h3>
                <p class="text-sm text-gray-600">View comprehensive report for all classes in your department</p>
            </a>

            <!-- Class Report -->
            <div class="bg-white rounded-xl shadow-md p-6 border border-gray-200">
                <div class="flex items-center justify-between mb-4">
                    <div class="h-12 w-12 bg-blue-100 rounded-lg flex items-center justify-center">
                        <svg class="w-6 h-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                        </svg>
                    </div>
                </div>
                <h3 class="text-lg font-semibold text-gray-900 mb-2">Class Report</h3>
                <p class="text-sm text-gray-600 mb-4">View detailed report for a specific class</p>
                
                <form method="GET" action="{{ route('hod.reports.class') }}" class="space-y-3">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Select Class</label>
                        <select name="class" required class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                            <option value="">Choose a class...</option>
                            @foreach(\App\Models\SchoolClass::where('term_id', $activeTerm->id)->where('department_id', auth()->user()->department_id)->orderBy('name')->get() as $class)
                                <option value="{{ $class->id }}">{{ $class->name }} @if($class->code)({{ $class->code }})@endif</option>
                            @endforeach
                        </select>
                    </div>
                    <button type="submit" class="w-full bg-purple-600 text-white px-4 py-2 rounded-lg hover:bg-purple-700 transition-colors font-medium">
                        Generate Report
                    </button>
                </form>
            </div>
        </div>

        <!-- Quick Stats -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Quick Statistics</h2>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div class="text-center p-4 bg-gray-50 rounded-lg">
                    <p class="text-2xl font-bold text-gray-900">{{ \App\Models\SchoolClass::where('term_id', $activeTerm->id)->where('department_id', auth()->user()->department_id)->count() }}</p>
                    <p class="text-sm text-gray-600 mt-1">Total Classes</p>
                </div>
                <div class="text-center p-4 bg-gray-50 rounded-lg">
                    <p class="text-2xl font-bold text-gray-900">{{ \App\Models\User::where('role', 'student')->whereHas('enrollments', function($q) use ($activeTerm) { $q->whereHas('schoolClass', function($q2) use ($activeTerm) { $q2->where('term_id', $activeTerm->id)->where('department_id', auth()->user()->department_id); }); })->distinct()->count() }}</p>
                    <p class="text-sm text-gray-600 mt-1">Total Students</p>
                </div>
                <div class="text-center p-4 bg-gray-50 rounded-lg">
                    <p class="text-2xl font-bold text-gray-900">{{ \App\Models\PoeSubmission::withoutGlobalScope('activeTerm')->whereHas('schoolClass', function($q) use ($activeTerm) { $q->where('term_id', $activeTerm->id)->where('department_id', auth()->user()->department_id); })->count() }}</p>
                    <p class="text-sm text-gray-600 mt-1">Total Submissions</p>
                </div>
            </div>
        </div>
    @endif
</div>
@endsection

