@extends('layouts.hod')

@section('title', 'Configure Unit')
@section('page-title', 'Configure Unit Assessment Structure')

@section('content')
<div class="mb-6">
    <a href="{{ route('hod.units.show', ['unit' => $unit, 'context' => 'departmental']) }}" class="text-purple-600 hover:text-purple-900 flex items-center">
        <svg class="h-5 w-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
        </svg>
        Back to Unit
    </a>
</div>

<div class="bg-white rounded-xl shadow-md p-6 mb-6">
    <h1 class="text-2xl font-bold text-gray-900 mb-2">{{ $unit->name }}</h1>
    <p class="text-sm text-gray-600">Code: {{ $unit->code }}</p>
    <p class="text-sm text-gray-500 mt-2">Department: {{ $unit->department->name ?? 'N/A' }}</p>
</div>

<div class="bg-white rounded-xl shadow-md p-6">
    <h2 class="text-xl font-semibold text-gray-900 mb-4">Unit Configuration</h2>
    <p class="text-sm text-gray-600 mb-6">
        Configure the unit classification and assessment structure. This defines how many assessments of each type are required for this unit.
    </p>

    <form method="POST" action="{{ route('hod.units.configure.store', $unit) }}">
        @csrf

        <!-- Unit Classification -->
        <div class="mb-6">
            <label for="classification" class="block text-sm font-medium text-gray-700 mb-2">
                Unit Classification <span class="text-red-500">*</span>
            </label>
            <select name="classification" id="classification" required
                    class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                <option value="">Select Classification</option>
                <option value="core_unit" {{ old('classification', $unit->classification) === 'core_unit' ? 'selected' : '' }}>
                    Core Unit
                </option>
                <option value="basic_unit" {{ old('classification', $unit->classification) === 'basic_unit' ? 'selected' : '' }}>
                    Basic Unit
                </option>
                <option value="common_unit" {{ old('classification', $unit->classification) === 'common_unit' ? 'selected' : '' }}>
                    Common Unit
                </option>
            </select>
            <p class="mt-1 text-xs text-gray-500">
                Core Unit: Typically requires more assessments. Basic Unit: Standard requirements. Common Unit: Minimal requirements.
            </p>
            @error('classification')
                <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
            @enderror
        </div>

        <!-- Assessment Structure -->
        <div class="mb-6">
            <h3 class="text-lg font-medium text-gray-900 mb-4">Assessment Structure</h3>
            <p class="text-sm text-gray-600 mb-4">
                Define how many assessments of each type are required for this unit. Trainers must create and complete all required assessments before the unit can be pushed to validation.
            </p>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <!-- Theory Assessments -->
                <div class="border border-gray-200 rounded-lg p-4">
                    <label for="theory_count" class="block text-sm font-medium text-gray-700 mb-2">
                        Theory Assessments <span class="text-red-500">*</span>
                    </label>
                    <p class="text-xs text-gray-500 mb-2">Includes: Assignments, Exams</p>
                    <input type="number" name="theory_count" id="theory_count" 
                           value="{{ old('theory_count', $unit->assessment_structure['theory'] ?? 0) }}"
                           min="0" max="20" required
                           class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                    @error('theory_count')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Practical Assessments -->
                <div class="border border-gray-200 rounded-lg p-4">
                    <label for="practical_count" class="block text-sm font-medium text-gray-700 mb-2">
                        Practical Assessments <span class="text-red-500">*</span>
                    </label>
                    <p class="text-xs text-gray-500 mb-2">Hands-on practical work</p>
                    <input type="number" name="practical_count" id="practical_count" 
                           value="{{ old('practical_count', $unit->assessment_structure['practical'] ?? 0) }}"
                           min="0" max="20" required
                           class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                    @error('practical_count')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Oral Assessments -->
                <div class="border border-gray-200 rounded-lg p-4">
                    <label for="oral_count" class="block text-sm font-medium text-gray-700 mb-2">
                        Oral Assessments <span class="text-red-500">*</span>
                    </label>
                    <p class="text-xs text-gray-500 mb-2">Oral presentations, viva voce</p>
                    <input type="number" name="oral_count" id="oral_count" 
                           value="{{ old('oral_count', $unit->assessment_structure['oral'] ?? 0) }}"
                           min="0" max="20" required
                           class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                    @error('oral_count')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- Project Assessments -->
                <div class="border border-gray-200 rounded-lg p-4">
                    <label for="project_count" class="block text-sm font-medium text-gray-700 mb-2">
                        Project Assessments <span class="text-red-500">*</span>
                    </label>
                    <p class="text-xs text-gray-500 mb-2">Project-based assessments</p>
                    <input type="number" name="project_count" id="project_count" 
                           value="{{ old('project_count', $unit->assessment_structure['project'] ?? 0) }}"
                           min="0" max="20" required
                           class="w-full rounded-md border-gray-300 shadow-sm focus:border-purple-500 focus:ring-purple-500">
                    @error('project_count')
                        <p class="mt-1 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>
            </div>
        </div>

        <!-- Help Text -->
        <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mb-6">
            <h4 class="text-sm font-medium text-blue-900 mb-2">💡 Configuration Guidelines</h4>
            <ul class="text-xs text-blue-800 space-y-1 list-disc list-inside">
                <li><strong>Core Unit:</strong> Typically requires 3 Theory, 3 Practical, 0-1 Oral, 0-1 Project</li>
                <li><strong>Basic Unit:</strong> Typically requires 2 Theory, 2 Practical, 0 Oral, 0 Project</li>
                <li><strong>Common Unit:</strong> Typically requires 1 Theory, 1 Practical, 0 Oral, 0 Project</li>
                <li>These are guidelines - adjust based on your department's requirements</li>
                <li>Once configured, trainers must complete all required assessments before validation</li>
            </ul>
        </div>

        <!-- Submit Button -->
        <div class="flex items-center justify-end gap-3">
            <a href="{{ route('hod.units.show', ['unit' => $unit, 'context' => 'departmental']) }}" 
               class="px-4 py-2 bg-gray-200 text-gray-700 rounded-md hover:bg-gray-300">
                Cancel
            </a>
            <button type="submit" 
                    class="px-4 py-2 bg-purple-600 text-white rounded-md hover:bg-purple-700">
                Save Configuration
            </button>
        </div>
    </form>
</div>
@endsection



