<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Units & Practical Checklists</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
        }
        .header {
            text-align: center;
            margin-bottom: 24px;
            padding-bottom: 12px;
            border-bottom: 1px solid #333;
        }
        .header h1 {
            margin: 0 0 8px 0;
            font-size: 18px;
        }
        .meta {
            font-size: 11px;
            color: #444;
        }
        .unit-block {
            margin-bottom: 20px;
            page-break-inside: avoid;
        }
        .unit-title {
            font-size: 14px;
            font-weight: bold;
            margin-bottom: 6px;
            color: #1a1a1a;
        }
        .unit-code {
            font-size: 11px;
            color: #555;
            margin-bottom: 8px;
        }
        .checklist-list {
            margin-left: 16px;
            margin-bottom: 4px;
        }
        .checklist-item {
            padding: 4px 0;
            border-bottom: 1px solid #eee;
            font-size: 11px;
        }
        .checklist-item:last-child {
            border-bottom: none;
        }
        .checklist-title {
            font-weight: 600;
        }
        .checklist-meta {
            color: #666;
            font-size: 10px;
            margin-top: 2px;
        }
        .no-checklists {
            margin-left: 16px;
            font-style: italic;
            color: #888;
            font-size: 11px;
        }
        .footer {
            margin-top: 24px;
            padding-top: 8px;
            border-top: 1px solid #ddd;
            text-align: right;
            font-size: 10px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Units & Practical Checklists</h1>
        <div class="meta">
            {{ $user->name }}
            @if($user->admission_number)
                &nbsp;|&nbsp; {{ $user->admission_number }}
            @endif
            &nbsp;|&nbsp; {{ $activeTerm->name }}
            &nbsp;|&nbsp; {{ now()->format('d M Y') }}
        </div>
    </div>

    <p style="margin-bottom: 16px;">This document lists your units and the practical checklists (practical assessments) for each unit in the active term.</p>

    @foreach($unitsWithChecklists as $item)
        <div class="unit-block">
            <div class="unit-title">{{ $item['unit']->name }}</div>
            @if($item['unit']->code)
                <div class="unit-code">Code: {{ $item['unit']->code }}</div>
            @endif
            <div class="checklist-list">
                @forelse($item['practical_assignments'] as $assignment)
                    <div class="checklist-item">
                        <span class="checklist-title">{{ $assignment->title }}</span>
                        <div class="checklist-meta">
                            @if($assignment->due_date)
                                Due: {{ $assignment->due_date->format('d M Y') }}
                            @endif
                            @if($assignment->total_marks)
                                &nbsp;|&nbsp; Total marks: {{ $assignment->total_marks }}
                            @endif
                        </div>
                    </div>
                @empty
                    <div class="no-checklists">No practical checklists for this unit.</div>
                @endforelse
            </div>
        </div>
    @endforeach

    @if($unitsWithChecklists->isEmpty())
        <p style="font-style: italic; color: #888;">No units or practical checklists found for the active term.</p>
    @endif

    <div class="footer">
        Generated from My Progress &nbsp;|&nbsp; {{ config('app.name') }}
    </div>
</body>
</html>
