@extends('layouts.trainer')

@section('title', 'My Profile')

@section('content')
    <div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">My Profile</h1>
            <p class="mt-1 text-sm text-gray-600">View and manage your profile information</p>
        </div>
        <a href="{{ route('trainer.profile.edit') }}" class="mt-4 sm:mt-0 inline-flex items-center px-4 py-2 bg-blue-600 border border-transparent rounded-md font-semibold text-xs text-white uppercase tracking-widest hover:bg-blue-700">
            <svg class="mr-2 h-4 w-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
            </svg>
            Edit Profile
        </a>
    </div>

    <div class="bg-white shadow rounded-lg overflow-hidden">
        <div class="px-6 py-5 border-b border-gray-200">
            <h2 class="text-lg font-semibold text-gray-900">Personal Information</h2>
        </div>
        <div class="px-6 py-5">
            <dl class="grid grid-cols-1 gap-x-4 gap-y-6 sm:grid-cols-2">
                <div>
                    <dt class="text-sm font-medium text-gray-500">Full Name</dt>
                    <dd class="mt-1 text-sm text-gray-900">{{ $user->name }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Email Address</dt>
                    <dd class="mt-1 text-sm text-gray-900">{{ $user->email }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Phone Number</dt>
                    <dd class="mt-1 text-sm text-gray-900">{{ $user->phone ?? 'Not provided' }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Department</dt>
                    <dd class="mt-1 text-sm text-gray-900">{{ $user->department->name ?? 'Not assigned' }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Role</dt>
                    <dd class="mt-1 text-sm text-gray-900 capitalize">{{ $user->role }}</dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Status</dt>
                    <dd class="mt-1">
                        <span class="px-2 py-1 text-xs rounded-full {{ $user->status === 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                            {{ ucfirst($user->status) }}
                        </span>
                    </dd>
                </div>
            </dl>
        </div>
    </div>

    <!-- Assigned Units -->
    <div class="mt-6 bg-white shadow rounded-lg overflow-hidden">
        <div class="px-6 py-5 border-b border-gray-200">
            <h2 class="text-lg font-semibold text-gray-900">Assigned Units</h2>
        </div>
        <div class="px-6 py-5">
            @if($assignedUnits->count() > 0)
                <div class="grid grid-cols-1 gap-4 sm:grid-cols-2 lg:grid-cols-3">
                    @foreach($assignedUnits as $unit)
                        <div class="border border-gray-200 rounded-lg p-4">
                            <h3 class="text-sm font-semibold text-gray-900">{{ $unit->name }}</h3>
                            @if($unit->code)
                                <p class="text-xs text-gray-500 mt-1">{{ $unit->code }}</p>
                            @endif
                            <p class="text-xs text-gray-600 mt-2">{{ $unit->department->name ?? '' }}</p>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-sm text-gray-500">No units assigned yet.</p>
            @endif
        </div>
    </div>

    <!-- Assigned Classes -->
    <div class="mt-6 bg-white shadow rounded-lg overflow-hidden">
        <div class="px-6 py-5 border-b border-gray-200">
            <h2 class="text-lg font-semibold text-gray-900">Assigned Classes & Units</h2>
        </div>
        <div class="px-6 py-5">
            @if($assignedClasses->count() > 0)
                <div class="space-y-4">
                    @foreach($assignedClasses as $classId => $allocations)
                        @php
                            $class = $allocations->first();
                            $className = $class->class_name ?? 'Unknown Class';
                            $classCode = $class->class_code ?? '';
                        @endphp
                        <div class="border border-gray-200 rounded-lg p-4">
                            <h3 class="text-sm font-semibold text-gray-900">{{ $className }}</h3>
                            @if($classCode)
                                <p class="text-xs text-gray-500 mt-1">{{ $classCode }}</p>
                            @endif
                            <div class="mt-3">
                                <p class="text-xs font-medium text-gray-700 mb-2">Units:</p>
                                <div class="flex flex-wrap gap-2">
                                    @foreach($allocations as $allocation)
                                        <span class="px-2 py-1 text-xs bg-blue-100 text-blue-800 rounded">
                                            {{ $allocation->unit_name }}
                                            @if($allocation->unit_code)
                                                ({{ $allocation->unit_code }})
                                            @endif
                                        </span>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <p class="text-sm text-gray-500">No class assignments yet.</p>
            @endif
        </div>
    </div>
@endsection

