@extends('layouts.trainer')

@section('title', 'Submission Details')

@section('content')
    <div class="mb-6">
        <a href="{{ route('trainer.submissions.index') }}" class="text-blue-600 hover:text-blue-900">
            ← Back to Submissions
        </a>
    </div>

    <div class="bg-white shadow rounded-lg p-6 mb-6">
        <h2 class="text-xl font-semibold text-gray-900 mb-4">Submission Details</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <p class="text-sm font-medium text-gray-500">Student</p>
                <p class="text-sm text-gray-900">{{ $submission->student->name }}</p>
                <p class="text-xs text-gray-500">{{ $submission->student->email }}</p>
            </div>
            <div>
                <p class="text-sm font-medium text-gray-500">Unit</p>
                <p class="text-sm text-gray-900">{{ $submission->unit->name }}</p>
            </div>
            <div>
                <p class="text-sm font-medium text-gray-500">Class</p>
                <p class="text-sm text-gray-900">{{ $submission->schoolClass->name }}</p>
            </div>
            <div>
                <p class="text-sm font-medium text-gray-500">Status</p>
                <span class="px-2 py-1 text-xs rounded-full 
                    @if($submission->status === 'trainer_approved') bg-green-100 text-green-800
                    @elseif($submission->status === 'rejected') bg-red-100 text-red-800
                    @elseif($submission->status === 'needs_revision') bg-yellow-100 text-yellow-800
                    @else bg-gray-100 text-gray-800
                    @endif">
                    {{ ucfirst(str_replace('_', ' ', $submission->status)) }}
                </span>
            </div>
        </div>
    </div>

    <!-- Evidence Files -->
    @if($submission->evidence->count() > 0)
        <div class="bg-white shadow rounded-lg p-6 mb-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Evidence Files</h3>
            <div class="space-y-2">
                @foreach($submission->evidence as $evidence)
                    <div class="flex items-center justify-between p-3 bg-gray-50 rounded">
                        <span class="text-sm text-gray-900">{{ $evidence->file_name }}</span>
                        <a href="{{ route('admin.submissions.evidence.download', $evidence) }}" class="text-blue-600 hover:text-blue-900 text-sm">Download</a>
                    </div>
                @endforeach
            </div>
        </div>
    @endif

    <!-- Reviews -->
    @if($submission->reviews->count() > 0)
        <div class="bg-white shadow rounded-lg p-6">
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Reviews</h3>
            <div class="space-y-4">
                @foreach($submission->reviews as $review)
                    <div class="border border-gray-200 rounded-lg p-4">
                        <div class="flex items-center justify-between mb-2">
                            <p class="text-sm font-medium text-gray-900">{{ $review->reviewer->name }}</p>
                            <span class="px-2 py-1 text-xs rounded-full 
                                @if($review->status === 'approved') bg-green-100 text-green-800
                                @elseif($review->status === 'rejected') bg-red-100 text-red-800
                                @else bg-yellow-100 text-yellow-800
                                @endif">
                                {{ ucfirst($review->status) }}
                            </span>
                        </div>
                        <p class="text-sm text-gray-600 mb-2">Marks: <strong>{{ number_format($review->marks, 2) }}/100</strong></p>
                        <p class="text-sm text-gray-900">{{ $review->feedback }}</p>
                        <p class="text-xs text-gray-500 mt-2">{{ $review->reviewed_at->format('M d, Y H:i') }}</p>
                    </div>
                @endforeach
            </div>
        </div>
    @endif
@endsection

