@extends('layouts.validator')

@section('title', 'Practical Evidence - ' . $student->name)

@section('content')
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-900">Practical Evidence</h1>
        <p class="mt-1 text-sm text-gray-600">{{ $student->name }} - {{ $unit->name }}</p>
    </div>

    @if($evidences->count() > 0)
        <div class="space-y-6">
            @foreach($evidences as $evidence)
                <div class="bg-white shadow-sm rounded-lg overflow-hidden">
                    <div class="px-6 py-4 border-b border-gray-200 bg-gray-50">
                        <div class="flex items-center justify-between">
                            <div>
                                <h3 class="text-lg font-semibold text-gray-900">{{ $evidence->task_name }}</h3>
                                <p class="text-sm text-gray-600 mt-1">Uploaded: {{ $evidence->uploaded_at->format('M d, Y h:i A') }}</p>
                            </div>
                            <div class="flex items-center gap-2">
                                <span class="px-2 py-1 text-xs font-semibold rounded-full 
                                    @if($evidence->isVideo()) bg-red-100 text-red-800
                                    @elseif($evidence->isImage()) bg-green-100 text-green-800
                                    @elseif($evidence->isAudio()) bg-purple-100 text-purple-800
                                    @else bg-blue-100 text-blue-800
                                    @endif">
                                    {{ ucfirst($evidence->evidence_type) }}
                                </span>
                                <span class="px-3 py-1 text-sm font-semibold rounded-full {{ $evidence->getStatusBadgeClasses() }}">
                                    {{ $evidence->getStatusLabel() }}
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="px-6 py-4">
                        @if($evidence->notes)
                            <div class="mb-4">
                                <p class="text-sm font-medium text-gray-700 mb-1">Student Notes:</p>
                                <p class="text-sm text-gray-900 bg-gray-50 p-3 rounded">{{ $evidence->notes }}</p>
                            </div>
                        @endif

                        <!-- Media Preview -->
                        <div class="mb-4">
                            @if($evidence->isVideo())
                                <video controls class="w-full rounded-lg" style="max-height: 500px;">
                                    <source src="{{ Storage::url($evidence->file_path) }}" type="{{ $evidence->mime_type }}">
                                    Your browser does not support the video tag.
                                </video>
                            @elseif($evidence->isImage())
                                <img src="{{ Storage::url($evidence->file_path) }}" alt="{{ $evidence->task_name }}" class="w-full rounded-lg" style="max-height: 500px; object-fit: contain;">
                            @elseif($evidence->isAudio())
                                <audio controls class="w-full">
                                    <source src="{{ Storage::url($evidence->file_path) }}" type="{{ $evidence->mime_type }}">
                                    Your browser does not support the audio tag.
                                </audio>
                            @else
                                <div class="text-center py-8 bg-gray-50 rounded-lg">
                                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                    </svg>
                                    <p class="mt-2 text-sm text-gray-500">Document file</p>
                                </div>
                            @endif
                        </div>

                        <div class="flex items-center justify-between pt-4 border-t border-gray-200">
                            <div>
                                <p class="text-sm font-medium text-gray-900">{{ $evidence->original_name }}</p>
                                <p class="text-xs text-gray-500">{{ $evidence->file_size_human }}</p>
                            </div>
                            <a href="{{ route('validator.practical-evidence.download', $evidence) }}" class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 text-sm font-medium">
                                Download
                            </a>
                        </div>

                        <!-- Comments -->
                        @if($evidence->comments->count() > 0)
                            <div class="mt-4 pt-4 border-t border-gray-200">
                                <h4 class="text-sm font-semibold text-gray-900 mb-3">Comments</h4>
                                <div class="space-y-3">
                                    @foreach($evidence->comments as $comment)
                                        <div class="border-l-4 border-indigo-500 pl-4 py-2">
                                            <div class="flex justify-between items-start mb-1">
                                                <div>
                                                    <p class="font-medium text-gray-900 text-sm">{{ $comment->user->name ?? 'Unknown' }}</p>
                                                    <p class="text-xs text-gray-500">{{ $comment->created_at->format('M d, Y h:i A') }}</p>
                                                </div>
                                                <span class="px-2 py-1 text-xs font-semibold rounded-full bg-indigo-100 text-indigo-800">
                                                    {{ ucfirst($comment->role) }}
                                                </span>
                                            </div>
                                            <p class="text-sm text-gray-700">{{ $comment->comment }}</p>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endif

                        <!-- Add Comment Form -->
                        <div class="mt-4 pt-4 border-t border-gray-200">
                            <form action="{{ route('validator.practical-evidence.comment', $evidence) }}" method="POST">
                                @csrf
                                <div class="flex gap-2">
                                    <textarea name="comment" rows="2" required class="flex-1 rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 text-sm" placeholder="Add a comment..."></textarea>
                                    <button type="submit" class="px-4 py-2 bg-gray-600 text-white rounded-md hover:bg-gray-700 text-sm font-medium">
                                        Comment
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    @else
        <div class="bg-white rounded-lg shadow-sm p-12 text-center">
            <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
            </svg>
            <h3 class="mt-2 text-sm font-medium text-gray-900">No evidence uploaded</h3>
            <p class="mt-1 text-sm text-gray-500">This student hasn't uploaded any practical evidence for this unit.</p>
        </div>
    @endif
@endsection

