@extends('layouts.validator')

@section('title', 'Validate Class - ' . $class->name)

@section('content')
<div class="mb-6">
    <a href="{{ route('validator.validation-requests.index') }}" class="text-indigo-600 hover:text-indigo-900 flex items-center mb-4">
        <svg class="h-5 w-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
        </svg>
        Back to Validation Requests
    </a>
    <h1 class="text-2xl font-bold text-gray-900">Validate Class</h1>
    <p class="mt-1 text-sm text-gray-600">{{ $class->name }} - {{ $unit->name }}</p>
</div>

<!-- Class Information -->
<div class="bg-white rounded-lg shadow mb-6 p-6">
    <h2 class="text-lg font-semibold text-gray-900 mb-4">Class Information</h2>
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
            <p class="text-sm text-gray-600">Class</p>
            <p class="text-sm font-medium text-gray-900">{{ $class->name }} ({{ $class->code }})</p>
        </div>
        <div>
            <p class="text-sm text-gray-600">Unit</p>
            <p class="text-sm font-medium text-gray-900">{{ $unit->name }} ({{ $unit->code }})</p>
            @if($unit->classification)
                <span class="inline-flex items-center px-2 py-1 mt-1 text-xs font-medium rounded-full 
                    @if($unit->classification === 'core_unit') bg-purple-100 text-purple-800
                    @elseif($unit->classification === 'basic_unit') bg-blue-100 text-blue-800
                    @else bg-gray-100 text-gray-800
                    @endif">
                    {{ ucfirst(str_replace('_', ' ', $unit->classification)) }}
                </span>
            @endif
        </div>
        <div>
            <p class="text-sm text-gray-600">Submitted By</p>
            <p class="text-sm font-medium text-gray-900">{{ $validationRequest->submitter->name }} ({{ ucfirst($validationRequest->submitted_role) }})</p>
        </div>
        <div>
            <p class="text-sm text-gray-600">Submitted At</p>
            <p class="text-sm font-medium text-gray-900">{{ $validationRequest->submitted_at->format('M d, Y H:i') }}</p>
        </div>
    </div>

    @if($classValidationRequests->count() > 1)
        <div class="mt-4 pt-4 border-t border-gray-200">
            <p class="text-sm font-medium text-gray-700 mb-2">Other Units in This Class:</p>
            <div class="flex flex-wrap gap-2">
                @foreach($classValidationRequests as $req)
                    @if($req->unit_id !== $unit->id)
                        <span class="px-3 py-1 text-xs font-medium rounded-full bg-gray-100 text-gray-800">
                            {{ $req->unit->name }}
                        </span>
                    @endif
                @endforeach
            </div>
        </div>
    @endif
</div>

<!-- Assessment Structure -->
@if($unit->isConfigured())
    <div class="bg-white rounded-lg shadow mb-6 p-6">
        <h2 class="text-lg font-semibold text-gray-900 mb-4">Assessment Structure</h2>
        @php
            $structure = $unit->getAssessmentStructure();
        @endphp
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
            <div class="text-center p-3 bg-blue-50 rounded-lg">
                <p class="text-xs text-gray-600 mb-1">Theory</p>
                <p class="text-lg font-semibold text-blue-700">{{ $structure['theory'] }}</p>
            </div>
            <div class="text-center p-3 bg-purple-50 rounded-lg">
                <p class="text-xs text-gray-600 mb-1">Practical</p>
                <p class="text-lg font-semibold text-purple-700">{{ $structure['practical'] }}</p>
            </div>
            <div class="text-center p-3 bg-green-50 rounded-lg">
                <p class="text-xs text-gray-600 mb-1">Oral</p>
                <p class="text-lg font-semibold text-green-700">{{ $structure['oral'] }}</p>
            </div>
            <div class="text-center p-3 bg-yellow-50 rounded-lg">
                <p class="text-xs text-gray-600 mb-1">Project</p>
                <p class="text-lg font-semibold text-yellow-700">{{ $structure['project'] }}</p>
            </div>
        </div>
    </div>
@endif

<!-- Student Marks Table -->
<div class="bg-white rounded-lg shadow mb-6 overflow-hidden">
    <div class="px-6 py-4 border-b border-gray-200">
        <h2 class="text-lg font-semibold text-gray-900">Student Marks</h2>
        <p class="text-sm text-gray-600">{{ $students->count() }} student(s)</p>
    </div>
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Student</th>
                    @foreach($assignments as $assignment)
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">
                            {{ $assignment->title }}<br>
                            <span class="text-gray-400">({{ ucfirst($assignment->type) }})</span>
                        </th>
                    @endforeach
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Media</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @foreach($students as $student)
                    @php
                        $evidenceCount = \App\Models\PracticalEvidence::where('unit_id', $unit->id)
                            ->where('student_id', $student->id)
                            ->count();
                    @endphp
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm font-medium text-gray-900">{{ $student->name }}</div>
                            <div class="text-sm text-gray-500">{{ $student->admission_number }}</div>
                        </td>
                        @foreach($assignments as $assignment)
                            @php
                                $marks = $marksData[$student->id][$assignment->id] ?? null;
                            @endphp
                            <td class="px-6 py-4 whitespace-nowrap text-sm">
                                @if($marks && $marks['marks'] !== null)
                                    <span class="font-medium text-gray-900">
                                        {{ number_format($marks['marks'], 2) }}{{ $assignment->total_marks ? '/' . $assignment->total_marks : '' }}
                                    </span>
                                    <span class="ml-2 text-xs px-2 py-1 rounded-full 
                                        @if($marks['status'] === 'marked') bg-green-100 text-green-800
                                        @elseif($marks['status'] === 'absent') bg-red-100 text-red-800
                                        @else bg-gray-100 text-gray-800
                                        @endif">
                                        {{ ucfirst(str_replace('_', ' ', $marks['status'])) }}
                                    </span>
                                @else
                                    <span class="text-gray-400">-</span>
                                @endif
                            </td>
                        @endforeach
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            @if($evidenceCount > 0)
                                <a href="{{ route('validator.practical-evidence.show', ['unit' => $unit->id, 'student' => $student->id]) }}" 
                                   class="inline-flex items-center px-3 py-1.5 bg-indigo-600 text-white rounded-md hover:bg-indigo-700 text-xs font-medium">
                                    <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15.172 7l-6.586 6.586a2 2 0 102.828 2.828l6.414-6.586a4 4 0 00-5.656-5.656l-6.415 6.585a6 6 0 108.486 8.486L20.5 13"></path>
                                    </svg>
                                    Media ({{ $evidenceCount }})
                                </a>
                            @else
                                <span class="text-gray-400">-</span>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>

<!-- Validation Form -->
<div class="bg-white rounded-lg shadow p-6">
    <h2 class="text-lg font-semibold text-gray-900 mb-4">Validation Decision</h2>
    <form method="POST" action="{{ route('validator.validation-requests.validate', $validationRequest) }}">
        @csrf
        <div class="space-y-4">
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Decision <span class="text-red-500">*</span></label>
                <select name="status" required class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">Select decision...</option>
                    <option value="approved">Approve</option>
                    <option value="rejected">Reject</option>
                </select>
            </div>
            <div>
                <label class="block text-sm font-medium text-gray-700 mb-2">Comments <span class="text-red-500">*</span></label>
                <textarea name="validation_comment" rows="4" required
                          placeholder="Enter your validation comments..."
                          class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"></textarea>
                <p class="mt-1 text-xs text-gray-500">Please provide detailed comments explaining your decision.</p>
            </div>
            <div class="flex items-center justify-end gap-3 pt-4 border-t border-gray-200">
                <a href="{{ route('validator.validation-requests.index') }}" 
                   class="px-4 py-2 border border-gray-300 rounded-md text-gray-700 hover:bg-gray-50">
                    Cancel
                </a>
                <button type="submit" 
                        class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700">
                    Submit Validation
                </button>
            </div>
        </div>
    </form>
</div>
@endsection



