<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <title>Units & Practical Checklists</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
        }
        .header {
            text-align: center;
            margin-bottom: 24px;
            padding-bottom: 12px;
            border-bottom: 1px solid #333;
        }
        .header h1 {
            margin: 0 0 8px 0;
            font-size: 18px;
        }
        .meta {
            font-size: 11px;
            color: #444;
        }
        .unit-block {
            margin-bottom: 20px;
            page-break-inside: avoid;
        }
        .unit-title {
            font-size: 14px;
            font-weight: bold;
            margin-bottom: 6px;
            color: #1a1a1a;
        }
        .unit-code {
            font-size: 11px;
            color: #555;
            margin-bottom: 8px;
        }
        .checklist-list {
            margin-left: 16px;
            margin-bottom: 4px;
        }
        .checklist-item {
            padding: 4px 0;
            border-bottom: 1px solid #eee;
            font-size: 11px;
        }
        .checklist-item:last-child {
            border-bottom: none;
        }
        .checklist-title {
            font-weight: 600;
        }
        .checklist-meta {
            color: #666;
            font-size: 10px;
            margin-top: 2px;
        }
        .no-checklists {
            margin-left: 16px;
            font-style: italic;
            color: #888;
            font-size: 11px;
        }
        .footer {
            margin-top: 24px;
            padding-top: 8px;
            border-top: 1px solid #ddd;
            text-align: right;
            font-size: 10px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>Units & Practical Checklists</h1>
        <div class="meta">
            <?php echo e($user->name); ?>

            <?php if($user->admission_number): ?>
                &nbsp;|&nbsp; <?php echo e($user->admission_number); ?>

            <?php endif; ?>
            &nbsp;|&nbsp; <?php echo e($activeTerm->name); ?>

            &nbsp;|&nbsp; <?php echo e(now()->format('d M Y')); ?>

        </div>
    </div>

    <p style="margin-bottom: 16px;">This document lists your units and the practical checklists (practical assessments) for each unit in the active term.</p>

    <?php $__currentLoopData = $unitsWithChecklists; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="unit-block">
            <div class="unit-title"><?php echo e($item['unit']->name); ?></div>
            <?php if($item['unit']->code): ?>
                <div class="unit-code">Code: <?php echo e($item['unit']->code); ?></div>
            <?php endif; ?>
            <div class="checklist-list">
                <?php $__empty_1 = true; $__currentLoopData = $item['practical_assignments']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <div class="checklist-item">
                        <span class="checklist-title"><?php echo e($assignment->title); ?></span>
                        <div class="checklist-meta">
                            <?php if($assignment->due_date): ?>
                                Due: <?php echo e($assignment->due_date->format('d M Y')); ?>

                            <?php endif; ?>
                            <?php if($assignment->total_marks): ?>
                                &nbsp;|&nbsp; Total marks: <?php echo e($assignment->total_marks); ?>

                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="no-checklists">No practical checklists for this unit.</div>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <?php if($unitsWithChecklists->isEmpty()): ?>
        <p style="font-style: italic; color: #888;">No units or practical checklists found for the active term.</p>
    <?php endif; ?>

    <div class="footer">
        Generated from My Progress &nbsp;|&nbsp; <?php echo e(config('app.name')); ?>

    </div>
</body>
</html>
<?php /**PATH D:\poe\resources\views/student/progress/units-checklist-pdf.blade.php ENDPATH**/ ?>