<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Practical Assessment Marks Report - <?php echo e($assignment->title); ?></title>
    <style>
        @media print {
            .no-print { display: none; }
            button { display: none; }
            body { margin: 10mm; padding: 0; }
            .page-break { page-break-after: always; }
            @page {
                size: A4;
                margin: 15mm;
            }
        }
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        body {
            font-family: 'Times New Roman', serif;
            font-size: 11pt;
            line-height: 1.4;
            color: #000;
            background: #fff;
            padding: 20px;
            display: flex;
            flex-direction: column;
            min-height: 100vh;
        }
        .letterhead {
            border-bottom: 3px solid #000;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        .letterhead-content {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            gap: 10px;
        }
        .logo-section {
            flex-shrink: 0;
        }
        .logo-section img {
            max-height: 80px;
            max-width: 120px;
            object-fit: contain;
        }
        .institution-info {
            width: 100%;
            text-align: center;
        }
        .institution-name {
            font-size: 22pt;
            font-weight: bold;
            text-transform: uppercase;
            margin-bottom: 4px;
            letter-spacing: 1.5px;
            text-align: center;
        }
        .department-name {
            font-size: 16pt;
            font-weight: bold;
            margin-top: 4px;
            margin-bottom: 8px;
            text-transform: uppercase;
            text-align: center;
        }
        .institution-details {
            font-size: 9pt;
            color: #333;
            line-height: 1.6;
            text-align: center;
        }
        .report-title {
            text-align: center;
            font-size: 20pt;
            font-weight: bold;
            text-transform: uppercase;
            margin: 25px 0 16px;
            padding-bottom: 6px;
            border-bottom: 2px solid #000;
            letter-spacing: 2px;
        }
        .metadata-section {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
            margin-bottom: 25px;
        }
        .metadata-column {
            padding: 4px 0;
        }
        .metadata-item {
            display: flex;
            margin-bottom: 6px;
        }
        .metadata-label {
            font-weight: bold;
            min-width: 140px;
            text-transform: uppercase;
            font-size: 9pt;
        }
        .metadata-value {
            flex: 1;
            font-size: 10pt;
        }
        .section-title {
            font-size: 11pt;
            font-weight: bold;
            text-transform: uppercase;
            border-bottom: 2px solid #000;
            padding-bottom: 6px;
            margin-bottom: 12px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px auto;
            font-size: 11pt;
            page-break-inside: auto;
            border: 2px solid #000;
        }
        th, td {
            padding: 12px 10px;
            text-align: center;
            vertical-align: middle;
            border: 1px solid #000;
        }
        th {
            background-color: #f5f5f5;
            font-weight: bold;
            font-size: 10pt;
            text-transform: uppercase;
            border: 1px solid #000;
        }
        tbody td {
            border: 1px solid #000;
        }
        .student-name-col {
            text-align: left;
            padding-left: 8px;
            min-width: 150px;
        }
        .admission-col {
            text-align: center;
            min-width: 100px;
        }
        .marks-col {
            text-align: center;
            min-width: 80px;
        }
        .status-col {
            text-align: center;
            min-width: 100px;
        }
        tbody tr {
            page-break-inside: avoid;
        }
        tbody tr:nth-child(even) {
            background-color: #f7f7f7;
        }
        .signature-row {
            display: flex;
            justify-content: space-between;
            gap: 40px;
            margin-top: auto;
            padding-top: 40px;
        }
        .content-wrapper {
            flex: 1;
            display: flex;
            flex-direction: column;
        }
        .signature-row div {
            width: 45%;
            font-size: 10pt;
        }
        .signature-row b {
            text-transform: uppercase;
        }
        .signature-row .signature-meta {
            margin-top: 8px;
        }
        .signature-row .signature-line-text {
            margin-top: 16px;
            font-size: 9pt;
        }
        .footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 1px solid #000;
            text-align: center;
            font-size: 9px;
            color: #666;
        }
        .footer-warning {
            font-weight: bold;
            color: #000;
            margin-bottom: 5px;
            font-size: 9px;
        }
        .status-badge {
            padding: 4px 8px;
            border-radius: 4px;
            font-size: 10px;
            font-weight: bold;
            display: inline-block;
        }
        .status-marked { background-color: #d1fae5; color: #065f46; }
        .status-not_marked { background-color: #fef3c7; color: #92400e; }
        .status-absent { background-color: #fee2e2; color: #991b1b; }
    </style>
</head>
<body>
    <div class="no-print" style="margin-bottom: 20px; text-align: right;">
        <button onclick="window.print()" style="padding: 10px 20px; background: #3b82f6; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 14px;">
            Print
        </button>
        <button onclick="window.close()" style="padding: 10px 20px; background: #6b7280; color: white; border: none; border-radius: 5px; cursor: pointer; margin-left: 10px; font-size: 14px;">
            Close
        </button>
    </div>

    <div class="content-wrapper">
        <!-- Letterhead -->
        <div class="letterhead">
            <div class="letterhead-content">
                <?php if(isset($institutionSettings['institution.logo']) && $institutionSettings['institution.logo']): ?>
                    <div class="logo-section">
                        <img src="<?php echo e(asset('storage/' . $institutionSettings['institution.logo'])); ?>" alt="Institution Logo">
                    </div>
                <?php endif; ?>
                <div class="institution-info">
                    <div class="institution-name">
                        <?php echo e($institutionSettings['institution.name'] ?? config('app.name', 'Technical and Vocational Education Training Institution')); ?>

                    </div>
                    <div class="department-name">
                        Department of <?php echo e($assignment->unit->department->name ?? 'Computing'); ?>

                    </div>
                    <?php if(isset($institutionSettings['institution.address']) && $institutionSettings['institution.address']): ?>
                        <div class="institution-details">
                            <?php echo e($institutionSettings['institution.address']); ?>

                            <?php if(isset($institutionSettings['institution.phone']) && $institutionSettings['institution.phone']): ?>
                                | Tel: <?php echo e($institutionSettings['institution.phone']); ?>

                            <?php endif; ?>
                            <?php if(isset($institutionSettings['institution.email']) && $institutionSettings['institution.email']): ?>
                                | Email: <?php echo e($institutionSettings['institution.email']); ?>

                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">
            PRACTICAL ASSESSMENT MARKS REPORT
        </div>

        <!-- Metadata Section -->
        <div class="metadata-section">
            <div class="metadata-column">
                <h4 class="section-title">Assignment Information</h4>
                <div class="metadata-item">
                    <span class="metadata-label">Assignment:</span>
                    <span class="metadata-value"><?php echo e($assignment->title); ?></span>
                </div>
                <div class="metadata-item">
                    <span class="metadata-label">Unit:</span>
                    <span class="metadata-value"><?php echo e($assignment->unit->name ?? 'N/A'); ?> (<?php echo e($assignment->unit->code ?? 'N/A'); ?>)</span>
                </div>
                <div class="metadata-item">
                    <span class="metadata-label">Trainer:</span>
                    <span class="metadata-value"><?php echo e($assignment->trainer->name ?? 'N/A'); ?></span>
                </div>
                <div class="metadata-item">
                    <span class="metadata-label">Date of Assessment:</span>
                    <span class="metadata-value"><?php echo e($assignment->due_date ? $assignment->due_date->format('d M Y') : 'N/A'); ?></span>
                </div>
            </div>
            <div class="metadata-column">
                <h4 class="section-title">Report Information</h4>
                <div class="metadata-item">
                    <span class="metadata-label">Total Marks:</span>
                    <span class="metadata-value"><?php echo e(number_format($assignment->total_marks, 2)); ?></span>
                </div>
                <div class="metadata-item">
                    <span class="metadata-label">Total Students:</span>
                    <span class="metadata-value"><?php echo e($submissions->count()); ?></span>
                </div>
                <div class="metadata-item">
                    <span class="metadata-label">Report Generated:</span>
                    <span class="metadata-value"><?php echo e(now()->format('d M Y, h:i A')); ?></span>
                </div>
            </div>
        </div>

        <?php if($submissions->count() > 0): ?>
            <table>
                <thead>
                    <tr>
                        <th style="width: 30px;">#</th>
                        <th class="student-name-col">Student Name</th>
                        <th class="admission-col">Admission Number</th>
                        <th class="status-col">Status</th>
                        <?php $__currentLoopData = $practicalColumns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $col): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <th class="marks-col">P<?php echo e($idx + 1); ?></th>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php $__currentLoopData = $oralColumns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $col): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <th class="marks-col">O<?php echo e($idx + 1); ?></th>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <th class="marks-col">Pav (%)</th>
                        <th class="marks-col">Oav (%)</th>
                        <th class="marks-col">Total Marks</th>
                        <th class="marks-col">Overall %</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $submissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $submission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $studentMarks = $taskMarks[$submission->id] ?? ['P' => [], 'O' => []];
                            $pTotal = array_sum($studentMarks['P']);
                            $oTotal = array_sum($studentMarks['O']);
                            $totalMarks = $pTotal + $oTotal;

                            $pMaxTotal = $practicalTotalMax ?? 0;
                            $oMaxTotal = $oralTotalMax ?? 0;

                            $pAvg = $pMaxTotal > 0 ? ($pTotal / $pMaxTotal) * 100 : null;
                            $oAvg = $oMaxTotal > 0 ? ($oTotal / $oMaxTotal) * 100 : null;

                            $overallMax = ($pMaxTotal + $oMaxTotal) ?: ($assignment->total_marks ?: 100);
                            $overallPercent = $overallMax > 0 ? ($totalMarks / $overallMax) * 100 : 0;
                        ?>
                        <tr>
                            <td><?php echo e($index + 1); ?></td>
                            <td class="student-name-col"><?php echo e($submission->student->name ?? 'N/A'); ?></td>
                            <td class="admission-col"><?php echo e($submission->student->admission_number ?? 'N/A'); ?></td>
                            <td class="status-col">
                                <?php if($submission->marking_status === 'marked'): ?>
                                    <span class="status-badge status-marked">Marked</span>
                                <?php elseif($submission->marking_status === 'absent'): ?>
                                    <span class="status-badge status-absent">Absent</span>
                                <?php else: ?>
                                    <span class="status-badge status-not_marked">Not Marked</span>
                                <?php endif; ?>
                            </td>
                            <?php $__currentLoopData = $practicalColumns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $col): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td class="marks-col">
                                    <?php echo e(number_format($studentMarks['P'][$idx] ?? 0, 2)); ?>

                                </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php $__currentLoopData = $oralColumns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $col): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td class="marks-col">
                                    <?php echo e(number_format($studentMarks['O'][$idx] ?? 0, 2)); ?>

                                </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <td class="marks-col">
                                <?php if(!is_null($pAvg)): ?>
                                    <?php echo e(number_format($pAvg, 2)); ?>%
                                <?php else: ?>
                                    —
                                <?php endif; ?>
                            </td>
                            <td class="marks-col">
                                <?php if(!is_null($oAvg)): ?>
                                    <?php echo e(number_format($oAvg, 2)); ?>%
                                <?php else: ?>
                                    —
                                <?php endif; ?>
                            </td>
                            <td class="marks-col"><?php echo e(number_format($totalMarks, 2)); ?></td>
                            <td class="marks-col"><?php echo e(number_format($overallPercent, 2)); ?>%</td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        <?php else: ?>
            <div style="text-align: center; padding: 40px; color: #666;">
                <p>No submissions found for this assignment.</p>
            </div>
        <?php endif; ?>
    </div>

    <!-- Signatures -->
    <div class="signature-row">
        <div>
            <b>Trainer / Assessor</b>
            <div class="signature-meta">
                Name: <?php echo e($trainer->name ?? '_____________________'); ?>

            </div>
            <div class="signature-line-text">
                Signature: _____________ &nbsp;&nbsp;&nbsp; Date: _______
            </div>
        </div>
        <div>
            <b>Head of Department / Verifier</b>
            <div class="signature-meta">
                Name: _____________________
            </div>
            <div class="signature-line-text">
                Signature: _____________ &nbsp;&nbsp;&nbsp; Date: _______
            </div>
        </div>
    </div>

    <!-- Footer -->
    <div class="footer">
        <div class="footer-warning">
            SYSTEM GENERATED REPORT – NO ALTERATIONS ALLOWED
        </div>
        <div>
            Generated on <?php echo e(now()->format('d M Y, h:i A')); ?> | <?php echo e($institutionSettings['institution.footer_text'] ?? config('app.name', 'e-PoE System')); ?>

        </div>
    </div>
</body>
</html>
<?php /**PATH D:\poe\resources\views/trainer/marks/print-assignment.blade.php ENDPATH**/ ?>