<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

        <?php
            $systemName = \App\Models\Setting::get('system.name', config('app.name', 'EPOE SYSTEM'));
            $favicon = \App\Models\Setting::get('system.favicon');
        ?>

        <title>Login - <?php echo e($systemName); ?></title>
        
        <?php if($favicon): ?>
            <link rel="icon" type="image/x-icon" href="<?php echo e(asset('storage/' . $favicon)); ?>">
        <?php endif; ?>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

        <!-- Scripts -->
        <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
        <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    </head>
    <body class="font-sans text-gray-900 antialiased">
        <?php echo e($slot); ?>

    </body>
</html>
<?php /**PATH D:\poe\resources\views/layouts/guest.blade.php ENDPATH**/ ?>