<?php $__env->startSection('title', 'View Assignment'); ?>
<?php $__env->startSection('page-title', 'View Assignment'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-7xl mx-auto">
    <div class="mb-6">
        <a href="<?php echo e(request('context') === 'departmental' ? route('hod.units.show', [$assignment->unit, 'context' => 'departmental']) : route('hod.units.show', $assignment->unit)); ?>" class="text-purple-600 hover:text-purple-900 flex items-center mb-4">
            <svg class="h-5 w-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
            Back to Unit
        </a>
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900"><?php echo e($assignment->title); ?></h1>
                <p class="mt-1 text-sm text-gray-500">Unit: <?php echo e($assignment->unit->name); ?> (<?php echo e($assignment->unit->code); ?>)</p>
            </div>
            <div class="flex gap-3">
                <a href="<?php echo e(route('hod.assignments.edit', $assignment)); ?>" 
                   class="inline-flex items-center px-4 py-2 bg-purple-600 text-white text-sm font-medium rounded-md hover:bg-purple-700">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                    </svg>
                    Edit
                </a>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <div class="lg:col-span-2 space-y-6">
            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex items-center gap-3 mb-4">
                    <span class="px-3 py-1 text-sm font-medium rounded <?php echo e($assignment->getStatusBadgeClasses()); ?>">
                        <?php echo e($assignment->getTypeLabel()); ?>

                    </span>
                    <?php if($assignment->is_published): ?>
                        <span class="px-3 py-1 text-sm font-medium rounded bg-green-100 text-green-800">Published</span>
                    <?php else: ?>
                        <span class="px-3 py-1 text-sm font-medium rounded bg-gray-100 text-gray-800">Draft</span>
                    <?php endif; ?>
                </div>

                <?php if($assignment->description): ?>
                    <div class="mb-4">
                        <h3 class="text-sm font-medium text-gray-700 mb-2">Description</h3>
                        <p class="text-gray-900"><?php echo e($assignment->description); ?></p>
                    </div>
                <?php endif; ?>

                <?php if($assignment->instructions): ?>
                    <div class="mb-4">
                        <h3 class="text-sm font-medium text-gray-700 mb-2">Instructions</h3>
                        <div class="text-gray-900 whitespace-pre-wrap"><?php echo e($assignment->instructions); ?></div>
                    </div>
                <?php endif; ?>

                <?php if($assignment->type !== 'practical' && $assignment->attachments && count($assignment->attachments) > 0): ?>
                    <div class="mb-4">
                        <h3 class="text-sm font-medium text-gray-700 mb-2">Attachments</h3>
                        <div class="space-y-2">
                            <?php $__currentLoopData = $assignment->attachments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $attachment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e(route('hod.assignments.attachment.download', ['assignment' => $assignment, 'index' => $index])); ?>" 
                                   class="flex items-center p-3 border border-gray-200 rounded-lg hover:bg-gray-50">
                                    <svg class="w-5 h-5 text-gray-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                    </svg>
                                    <span class="text-sm text-gray-900"><?php echo e(basename($attachment)); ?></span>
                                </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if($assignment->type === 'practical'): ?>
                    <?php if($assignment->candidate_tool && count($assignment->candidate_tool) > 0): ?>
                        <div class="mb-4">
                            <h3 class="text-sm font-medium text-gray-700 mb-2">Candidate Tool</h3>
                            <div class="space-y-2">
                                <?php $__currentLoopData = $assignment->candidate_tool; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $tool): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="<?php echo e(route('hod.assignments.tool.download', [$assignment, 'candidate', $index])); ?>" 
                                       class="flex items-center p-3 border border-blue-200 rounded-lg hover:bg-blue-50">
                                        <svg class="w-5 h-5 text-blue-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                        </svg>
                                        <span class="text-sm text-gray-900"><?php echo e(basename($tool)); ?></span>
                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if($assignment->assessor_tool && count($assignment->assessor_tool) > 0): ?>
                        <div class="mb-4">
                            <h3 class="text-sm font-medium text-gray-700 mb-2">Assessor Tool</h3>
                            <div class="space-y-2">
                                <?php $__currentLoopData = $assignment->assessor_tool; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $tool): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <a href="<?php echo e(route('hod.assignments.tool.download', [$assignment, 'assessor', $index])); ?>" 
                                       class="flex items-center p-3 border border-purple-200 rounded-lg hover:bg-purple-50">
                                        <svg class="w-5 h-5 text-purple-400 mr-3" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z"></path>
                                        </svg>
                                        <span class="text-sm text-gray-900"><?php echo e(basename($tool)); ?></span>
                                    </a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>
        </div>

        <div class="space-y-6">
            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Assignment Details</h3>
                <dl class="space-y-3">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Type</dt>
                        <dd class="mt-1 text-sm text-gray-900"><?php echo e($assignment->getTypeLabel()); ?></dd>
                    </div>
                    <?php if($assignment->total_marks): ?>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Total Marks</dt>
                            <dd class="mt-1 text-sm text-gray-900"><?php echo e($assignment->total_marks); ?></dd>
                        </div>
                    <?php endif; ?>
                    <?php if($assignment->start_date): ?>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Start Date</dt>
                            <dd class="mt-1 text-sm text-gray-900"><?php echo e($assignment->start_date->format('M d, Y H:i')); ?></dd>
                        </div>
                    <?php endif; ?>
                    <?php if($assignment->due_date): ?>
                        <div>
                            <dt class="text-sm font-medium text-gray-500">Due Date</dt>
                            <dd class="mt-1 text-sm text-gray-900"><?php echo e($assignment->due_date->format('M d, Y H:i')); ?></dd>
                        </div>
                    <?php endif; ?>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Status</dt>
                        <dd class="mt-1">
                            <?php if($assignment->is_published): ?>
                                <span class="px-2 py-1 text-xs font-medium rounded bg-green-100 text-green-800">Published</span>
                            <?php else: ?>
                                <span class="px-2 py-1 text-xs font-medium rounded bg-gray-100 text-gray-800">Draft</span>
                            <?php endif; ?>
                        </dd>
                    </div>
                </dl>
            </div>

            <div class="bg-white rounded-lg shadow p-6">
                <h3 class="text-lg font-semibold text-gray-900 mb-4">Submissions</h3>
                <dl class="space-y-3">
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Total</dt>
                        <dd class="mt-1 text-2xl font-semibold text-gray-900"><?php echo e($submissionsCount); ?></dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Submitted</dt>
                        <dd class="mt-1 text-lg text-gray-900"><?php echo e($submittedCount); ?></dd>
                    </div>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Graded</dt>
                        <dd class="mt-1 text-lg text-gray-900"><?php echo e($gradedCount); ?></dd>
                    </div>
                </dl>
                <?php if($assignment->type === 'practical'): ?>
                    <div class="mt-4 pt-4 border-t border-gray-200 space-y-2">
                        <a href="<?php echo e(route('hod.assessor-tool.marking', $assignment)); ?>" 
                           class="block w-full text-center px-4 py-2 bg-purple-600 text-white rounded-md hover:bg-purple-700 text-sm font-medium">
                            Mark Assessor Tool
                        </a>
                        <a href="<?php echo e(route('hod.practical-marks.index', $assignment)); ?>" 
                           class="block w-full text-center px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700 text-sm font-medium">
                            View Compiled Marks
                        </a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <?php if($assignment->type !== 'practical' && isset($submissions) && $submissions->count() > 0): ?>
        <div class="mt-6 bg-white rounded-lg shadow">
            <div class="px-6 py-4 border-b border-gray-200">
                <h2 class="text-lg font-semibold text-gray-900">Student Submissions</h2>
            </div>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Student</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Admission No</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Submitted</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Marks</th>
                            <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">Actions</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php $__currentLoopData = $submissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900"><?php echo e($submission->student->name ?? 'N/A'); ?></div>
                                    <div class="text-sm text-gray-500"><?php echo e($submission->student->email ?? 'N/A'); ?></div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    <?php echo e($submission->student->admission_number ?? 'N/A'); ?>

                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    <?php echo e($submission->submitted_at ? $submission->submitted_at->format('M d, Y H:i') : 'Not submitted'); ?>

                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-2 py-1 text-xs rounded-full <?php echo e($submission->getStatusBadgeClasses()); ?>">
                                        <?php echo e(ucfirst($submission->status)); ?>

                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                    <?php if($submission->marks !== null): ?>
                                        <span class="font-medium"><?php echo e(number_format($submission->marks, 2)); ?> / <?php echo e($assignment->total_marks ?? 'N/A'); ?></span>
                                    <?php else: ?>
                                        <span class="text-gray-400">Not graded</span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                    <a href="<?php echo e(route('hod.assignments.submissions.show', ['assignment' => $assignment, 'submission' => $submission])); ?>" 
                                       class="text-purple-600 hover:text-purple-900">
                                        <?php if($submission->marks === null): ?>
                                            Mark
                                        <?php else: ?>
                                            View/Edit
                                        <?php endif; ?>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php elseif($assignment->type !== 'practical'): ?>
        <div class="mt-6 bg-white rounded-lg shadow p-8 text-center">
            <p class="text-sm text-gray-500">No submissions yet.</p>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.hod', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/hod/assignments/show.blade.php ENDPATH**/ ?>