

<?php $__env->startSection('title', 'Admin Dashboard'); ?>
<?php $__env->startSection('page-title', 'Admin Dashboard'); ?>

<?php $__env->startSection('content'); ?>
    <!-- Statistics Cards -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
                <!-- Total Users -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6 text-gray-900">
                        <div class="flex items-center">
                            <div class="flex-shrink-0 bg-indigo-500 rounded-md p-3">
                                <svg class="h-6 w-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Total Users</p>
                                <p class="text-2xl font-semibold text-gray-900"><?php echo e($stats['total_users']); ?></p>
                                <p class="text-xs text-green-600 mt-1"><?php echo e($stats['active_users']); ?> active</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Terms -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6 text-gray-900">
                        <div class="flex items-center">
                            <div class="flex-shrink-0 bg-green-500 rounded-md p-3">
                                <svg class="h-6 w-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Terms</p>
                                <p class="text-2xl font-semibold text-gray-900"><?php echo e($stats['total_terms']); ?></p>
                                <p class="text-xs text-green-600 mt-1"><?php echo e($stats['active_terms']); ?> active</p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Classes -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6 text-gray-900">
                        <div class="flex items-center">
                            <div class="flex-shrink-0 bg-blue-500 rounded-md p-3">
                                <svg class="h-6 w-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">Classes</p>
                                <p class="text-2xl font-semibold text-gray-900"><?php echo e($stats['total_classes']); ?></p>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- PoE Submissions -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6 text-gray-900">
                        <div class="flex items-center">
                            <div class="flex-shrink-0 bg-purple-500 rounded-md p-3">
                                <svg class="h-6 w-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                            </div>
                            <div class="ml-4">
                                <p class="text-sm font-medium text-gray-500">PoE Submissions</p>
                                <p class="text-2xl font-semibold text-gray-900"><?php echo e($stats['total_submissions']); ?></p>
                                <p class="text-xs text-yellow-600 mt-1"><?php echo e($stats['pending_submissions']); ?> pending</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Users by Role -->
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg mb-8">
                <div class="p-6">
                    <h3 class="text-lg font-semibold text-gray-900 mb-4">Users by Role</h3>
                    <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-4">
                        <?php $__currentLoopData = ['admin', 'hod', 'trainer', 'exams_office', 'validator', 'student']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="text-center p-4 bg-gray-50 rounded-lg">
                                <p class="text-2xl font-bold text-gray-900"><?php echo e($usersByRole[$role] ?? 0); ?></p>
                                <p class="text-sm text-gray-600 capitalize"><?php echo e(str_replace('_', ' ', $role)); ?></p>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>

            <!-- Two Column Layout -->
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                <!-- Recent Submissions -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Recent Submissions</h3>
                        <div class="space-y-4">
                            <?php $__empty_1 = true; $__currentLoopData = $recentSubmissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="border-l-4 border-indigo-500 pl-4 py-2">
                                    <div class="flex justify-between items-start">
                                        <div>
                                            <p class="font-medium text-gray-900"><?php echo e($submission->student->name); ?></p>
                                            <p class="text-sm text-gray-600"><?php echo e($submission->unit->name); ?></p>
                                            <p class="text-xs text-gray-500"><?php echo e($submission->schoolClass->name); ?></p>
                                        </div>
                                        <span class="px-2 py-1 text-xs rounded-full 
                                            <?php if($submission->status === 'validator_approved'): ?> bg-green-100 text-green-800
                                            <?php elseif($submission->status === 'rejected'): ?> bg-red-100 text-red-800
                                            <?php else: ?> bg-yellow-100 text-yellow-800
                                            <?php endif; ?>">
                                            <?php echo e(str_replace('_', ' ', $submission->status)); ?>

                                        </span>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <p class="text-gray-500 text-sm">No submissions yet</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Recent Terms & Classes -->
                <div class="bg-white overflow-hidden shadow-sm sm:rounded-lg">
                    <div class="p-6">
                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Recent Terms</h3>
                        <div class="space-y-3 mb-6">
                            <?php $__empty_1 = true; $__currentLoopData = $recentTerms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $term): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="flex justify-between items-center p-3 bg-gray-50 rounded-lg">
                                    <div>
                                        <p class="font-medium text-gray-900"><?php echo e($term->name); ?></p>
                                        <p class="text-xs text-gray-600">
                                            <?php echo e($term->start_date->format('M d, Y')); ?> - <?php echo e($term->end_date->format('M d, Y')); ?>

                                        </p>
                                    </div>
                                    <span class="px-2 py-1 text-xs rounded-full 
                                        <?php if($term->status === 'active'): ?> bg-green-100 text-green-800
                                        <?php elseif($term->status === 'completed'): ?> bg-gray-100 text-gray-800
                                        <?php else: ?> bg-yellow-100 text-yellow-800
                                        <?php endif; ?>">
                                        <?php echo e(ucfirst($term->status)); ?>

                                    </span>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <p class="text-gray-500 text-sm">No terms yet</p>
                            <?php endif; ?>
                        </div>

                        <h3 class="text-lg font-semibold text-gray-900 mb-4">Recent Classes</h3>
                        <div class="space-y-3">
                            <?php $__empty_1 = true; $__currentLoopData = $recentClasses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <div class="p-3 bg-gray-50 rounded-lg">
                                    <p class="font-medium text-gray-900"><?php echo e($class->name); ?></p>
                                    <p class="text-xs text-gray-600">
                                        <?php echo e($class->department->name); ?> • <?php echo e($class->level->name); ?> • <?php echo e($class->term->name); ?>

                                    </p>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <p class="text-gray-500 text-sm">No classes yet</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>