<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Unit Summary Marks – <?php echo e($validationRequest->unit->name); ?></title>
    <style>
        @media print {
            .no-print { display: none !important; }
            body { margin: 0; }
        }
        body { font-family: Arial, sans-serif; font-size: 11pt; padding: 20px; }
        .letterhead { border-bottom: 2px solid #000; padding-bottom: 8px; margin-bottom: 12px; }
        .institution-name { font-size: 16pt; font-weight: bold; text-align: center; }
        .report-title { font-size: 14pt; font-weight: bold; text-align: center; margin: 12px 0; }
        .meta { font-size: 10pt; margin-bottom: 12px; }
        table { width: 100%; border-collapse: collapse; font-size: 10pt; }
        th, td { border: 1px solid #000; padding: 6px 8px; }
        th { background: #f0f0f0; font-weight: bold; }
        .text-left { text-align: left; }
        .text-center { text-align: center; }
        .total-col { font-weight: bold; background: #f5f5f5; }
    </style>
</head>
<body>
    <div class="no-print" style="margin-bottom: 16px;">
        <button type="button" onclick="window.print()" style="padding: 8px 16px; background: #4f46e5; color: white; border: none; border-radius: 6px; cursor: pointer;">Print / Save as PDF</button>
        <a href="<?php echo e(route('validator.validation-requests.show', ['class' => $validationRequest->class_id, 'unit' => $validationRequest->unit_id])); ?>" style="margin-left: 8px; padding: 8px 16px; background: #e5e7eb; color: #374151; text-decoration: none; border-radius: 6px;">Back to Validation</a>
    </div>

    <div class="letterhead">
        <div class="institution-name"><?php echo e($institutionSettings['institution.name'] ?? config('app.name')); ?></div>
    </div>

    <h1 class="report-title">Unit Summary Marks – Validator Preview</h1>

    <div class="meta">
        <strong>Unit:</strong> <?php echo e($validationRequest->unit->name); ?> (<?php echo e($validationRequest->unit->code); ?>)<br>
        <strong>Class:</strong> <?php echo e($validationRequest->schoolClass->name); ?> (<?php echo e($validationRequest->schoolClass->code); ?>)<br>
        <strong>Term:</strong> <?php echo e($activeTerm->name); ?><br>
        <strong>Submitted by:</strong> <?php echo e($validationRequest->submitter->name ?? '—'); ?> on <?php echo e($validationRequest->submitted_at->format('M d, Y H:i')); ?>

    </div>

    <table>
        <thead>
            <tr>
                <th class="text-left">#</th>
                <th class="text-left">Student</th>
                <th class="text-center">Admission No</th>
                <?php $__currentLoopData = $assignments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <th class="text-center"><?php echo e(Str::limit($a->title, 15)); ?><br><span style="font-size: 8pt;">(<?php echo e(ucfirst($a->type)); ?>)</span></th>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <th class="text-center total-col">Total %</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $idx => $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $data = $marksData[$student->id] ?? null; ?>
                <tr>
                    <td class="text-center"><?php echo e($idx + 1); ?></td>
                    <td class="text-left"><?php echo e($student->name); ?></td>
                    <td class="text-center"><?php echo e($student->admission_number ?? '—'); ?></td>
                    <?php $__currentLoopData = $assignments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assignment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $cell = $data['marks'][$assignment->id] ?? null;
                            $mark = $cell['marks'] ?? null;
                            $status = $cell['status'] ?? null;
                        ?>
                        <td class="text-center">
                            <?php if($mark !== null): ?>
                                <?php echo e(number_format($mark, 1)); ?><?php echo e($assignment->total_marks ? '/' . $assignment->total_marks : ''); ?>

                                <?php if($status === 'absent'): ?> <span style="font-size: 8pt;">(Absent)</span> <?php endif; ?>
                            <?php else: ?>
                                —
                            <?php endif; ?>
                        </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <td class="text-center total-col"><?php echo e($data ? number_format($data['percentage'], 1) . '%' : '—'); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>
</html>
<?php /**PATH D:\poe\resources\views/validator/marks/print-unit.blade.php ENDPATH**/ ?>