

<?php $__env->startSection('title', 'Student Portfolio'); ?>

<?php $__env->startSection('content'); ?>
    <?php
        use Illuminate\Support\Str;
    ?>

    <div class="mb-6">
        <a href="<?php echo e(route('validator.validation-requests.portfolio', $validationRequest)); ?>"
           class="text-indigo-600 hover:text-indigo-900 flex items-center text-sm">
            <svg class="h-5 w-5 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
            </svg>
            Back to Student List
        </a>
        <h2 class="mt-3 text-xl font-semibold text-gray-900">
            Portfolio Evidence &middot;
            <span class="text-gray-700"><?php echo e($student->name); ?></span>
        </h2>
        <p class="mt-1 text-sm text-gray-500">
            Unit: <?php echo e($validationRequest->unit->name); ?> (<?php echo e($validationRequest->unit->code); ?>) &middot;
            Class: <?php echo e($validationRequest->schoolClass->name); ?> (<?php echo e($validationRequest->schoolClass->code); ?>)
        </p>
    </div>

    <div x-data="{ open: false, active: null }" x-cloak>
        <div class="bg-white shadow-sm rounded-lg">
            <div class="px-6 py-4 border-b border-gray-200 bg-gray-50 flex items-center justify-between">
                <div>
                    <h3 class="text-lg font-semibold text-gray-900">Evidence Gallery</h3>
                    <p class="mt-1 text-sm text-gray-500">
                       
                    </p>
                </div>
            </div>

            <div class="px-6 py-4">
                <?php
                    $hasEvidence = false;
                ?>

                <div class="grid gap-4 grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4">
                    <?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $files = $task->evidenceFiles();
                        ?>
                        <?php $__currentLoopData = $files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php $hasEvidence = true; ?>
                            <?php
                                $url = asset('storage/' . $file->file_path);
                                $rawType = $file->evidence_type ?? Str::before($file->mime_type ?? '', '/');
                                $ext = strtolower(pathinfo($file->original_name ?? '', PATHINFO_EXTENSION));
                                $isPdf = $ext === 'pdf' || str_contains(strtolower($file->mime_type ?? ''), 'pdf');
                                $type = $isPdf ? 'pdf' : $rawType;
                            ?>
                            <button
                                type="button"
                                class="group relative bg-white border border-gray-200 rounded-lg overflow-hidden shadow-sm hover:shadow-md transition-shadow flex flex-col text-left"
                                @click="open = true; active = {
                                    url: '<?php echo e($url); ?>',
                                    type: '<?php echo e($type); ?>',
                                    mime: '<?php echo e($file->mime_type); ?>',
                                    name: <?php echo \Illuminate\Support\Js::from($file->original_name)->toHtml() ?>,
                                    task: <?php echo \Illuminate\Support\Js::from($task->task_name)->toHtml() ?>,
                                    uploaded_at: '<?php echo e(optional($file->uploaded_at)->format('M d, Y H:i')); ?>'
                                }"
                            >
                                <div class="aspect-video bg-gray-100 flex items-center justify-center overflow-hidden">
                                    <?php if(method_exists($file, 'isImage') && $file->isImage()): ?>
                                        <img src="<?php echo e($url); ?>"
                                             alt="<?php echo e($file->original_name); ?>"
                                             class="w-full h-full object-cover group-hover:scale-105 transition-transform">
                                    <?php elseif(method_exists($file, 'isVideo') && $file->isVideo()): ?>
                                        <div class="flex flex-col items-center justify-center text-gray-500">
                                            <svg class="h-10 w-10 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                      d="M14.752 11.168l-3.197-2.132A1 1 0 0010 9.868v4.264a1 1 0 001.555.832l3.197-2.132a1 1 0 000-1.664z" />
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                      d="M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                                            </svg>
                                            <span class="text-xs font-medium uppercase tracking-wide">Video</span>
                                        </div>
                                    <?php elseif(method_exists($file, 'isAudio') && $file->isAudio()): ?>
                                        <div class="flex flex-col items-center justify-center text-gray-500">
                                            <svg class="h-10 w-10 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                      d="M9 19V6l12-2v13" />
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                      d="M5 8v11a4 4 0 004 4h0a4 4 0 004-4V7" />
                                            </svg>
                                            <span class="text-xs font-medium uppercase tracking-wide">Audio</span>
                                        </div>
                                    <?php elseif($isPdf): ?>
                                        <div class="flex flex-col items-center justify-center text-red-600">
                                            <svg class="h-10 w-10 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                      d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                                            </svg>
                                            <span class="text-xs font-medium uppercase tracking-wide">PDF</span>
                                        </div>
                                    <?php else: ?>
                                        <div class="flex flex-col items-center justify-center text-gray-500">
                                            <svg class="h-10 w-10 mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                      d="M7 21h10a2 2 0 002-2V9.414a1 1 0 00-.293-.707l-5.414-5.414A1 1 0 0012.586 3H7a2 2 0 00-2 2v14a2 2 0 002 2z" />
                                            </svg>
                                            <span class="text-xs font-medium uppercase tracking-wide">
                                                <?php echo e(strtoupper(pathinfo($file->original_name, PATHINFO_EXTENSION)) ?: 'DOC'); ?>

                                            </span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="p-3 flex-1 flex flex-col">
                                    <p class="text-xs font-semibold text-indigo-700 mb-1 truncate">
                                        <?php echo e($task->task_name); ?>

                                    </p>
                                    <p class="text-sm font-medium text-gray-900 truncate">
                                        <?php echo e($file->original_name); ?>

                                    </p>
                                    <p class="mt-1 text-xs text-gray-500">
                                        <?php echo e(optional($file->uploaded_at)->format('M d, Y H:i') ?? 'Uploaded date not available'); ?>

                                    </p>
                                </div>
                            </button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php if(!$hasEvidence): ?>
                        <p class="text-sm text-gray-500 col-span-full">
                            This student has not uploaded any portfolio evidence for this unit.
                        </p>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Modal preview – larger, with PDF iframe and Escape to close -->
        <div
            class="fixed inset-0 z-40 flex items-center justify-center p-4 bg-black/70"
            x-show="open"
            x-transition:enter="transition ease-out duration-200"
            x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100"
            x-transition:leave="transition ease-in duration-150"
            x-transition:leave-start="opacity-100"
            x-transition:leave-end="opacity-0"
            @keydown.escape.window="open = false"
        >
            <div
                class="bg-white rounded-xl shadow-2xl w-full max-w-6xl max-h-[92vh] flex flex-col"
                @click.away="open = false"
            >
                <div class="px-5 py-4 border-b border-gray-200 flex items-center justify-between flex-shrink-0 bg-white">
                    <div class="min-w-0 pr-4">
                        <h3 class="text-base font-semibold text-gray-900 truncate" x-text="active?.name || 'Preview'"></h3>
                        <p class="text-sm text-gray-500 truncate" x-text="active?.task ? 'Task: ' + active.task : ''"></p>
                    </div>
                    <div class="flex items-center gap-2 flex-shrink-0">
                        <a
                            x-show="active?.url"
                            :href="active?.url"
                            target="_blank"
                            rel="noopener"
                            class="inline-flex items-center px-3 py-2 text-sm font-medium text-indigo-700 bg-indigo-50 rounded-lg hover:bg-indigo-100"
                        >
                            Open in new tab
                        </a>
                        <button
                            type="button"
                            class="p-2 text-gray-400 hover:text-gray-600 hover:bg-gray-100 rounded-lg"
                            @click="open = false"
                            aria-label="Close"
                        >
                            <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"/>
                            </svg>
                        </button>
                    </div>
                </div>

                <div class="flex-1 min-h-0 overflow-auto bg-gray-100 p-4">
                    <template x-if="active && active.type === 'image'">
                        <div class="flex justify-center items-start">
                            <img :src="active.url" :alt="active.name" class="max-w-full max-h-[75vh] rounded-lg shadow-lg object-contain" />
                        </div>
                    </template>

                    <template x-if="active && active.type === 'video'">
                        <div class="flex justify-center items-start">
                            <video controls class="w-full max-h-[75vh] rounded-lg shadow-lg bg-black" preload="metadata">
                                <source :src="active.url" :type="active.mime">
                                Your browser does not support the video tag.
                            </video>
                        </div>
                    </template>

                    <template x-if="active && active.type === 'audio'">
                        <div class="max-w-xl mx-auto py-8">
                            <div class="bg-white rounded-xl shadow p-6">
                                <p class="text-sm font-medium text-gray-700 mb-3" x-text="active?.name"></p>
                                <audio controls class="w-full">
                                    <source :src="active.url" :type="active.mime">
                                    Your browser does not support the audio element.
                                </audio>
                            </div>
                        </div>
                    </template>

                    <template x-if="active && active.type === 'pdf'">
                        <div class="bg-white rounded-lg shadow overflow-hidden" style="height: 78vh;">
                            <iframe
                                :src="active.url"
                                class="w-full h-full border-0"
                                title="PDF preview"
                            ></iframe>
                        </div>
                    </template>

                    <template x-if="active && !['image','video','audio','pdf'].includes(active?.type)">
                        <div class="flex flex-col items-center justify-center py-16 px-4">
                            <div class="bg-white rounded-xl shadow p-8 max-w-md text-center">
                                <p class="text-gray-600 mb-4">
                                    This file type cannot be previewed in the browser. Open it in a new tab or download it.
                                </p>
                                <a
                                    :href="active?.url"
                                    target="_blank"
                                    rel="noopener"
                                    class="inline-flex items-center px-5 py-2.5 bg-indigo-600 text-white text-sm font-medium rounded-lg hover:bg-indigo-700"
                                >
                                    Open / Download
                                </a>
                            </div>
                        </div>
                    </template>
                </div>

                <div class="px-5 py-3 border-t border-gray-200 flex-shrink-0 bg-white text-sm text-gray-500">
                    <span x-text="active?.uploaded_at ? 'Uploaded: ' + active.uploaded_at : ''"></span>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.validator', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/validator/portfolio/show.blade.php ENDPATH**/ ?>