<?php $__env->startSection('title', 'Trainer Dashboard'); ?>
<?php $__env->startSection('page-title', 'Dashboard'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Welcome Section with Action Buttons -->
    <div class="bg-gradient-to-r from-blue-500 to-blue-600 rounded-lg shadow-lg p-4 sm:p-6 text-white">
        <div class="flex flex-col md:flex-row md:items-center md:justify-between">
            <div class="flex-1 mb-4 md:mb-0">
                <h1 class="text-2xl sm:text-3xl font-bold mb-2">Welcome back, <?php echo e(auth()->user()->name); ?>!</h1>
                <div class="flex flex-col sm:flex-row sm:flex-wrap items-start sm:items-center gap-2 sm:gap-3 mt-3">
                    <?php if($activeTerm): ?>
                        <span class="inline-flex items-center px-2 sm:px-3 py-1 rounded-full text-xs sm:text-sm font-semibold bg-white bg-opacity-20 text-white border border-white border-opacity-30">
                            <svg class="w-3 h-3 sm:w-4 sm:h-4 mr-1.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7V3m8 4V3m-9 8h10M5 21h14a2 2 0 002-2V7a2 2 0 00-2-2H5a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                            </svg>
                            <?php echo e($activeTerm->name); ?>

                        </span>
                    <?php endif; ?>
                    <?php if(auth()->user()->department): ?>
                        <span class="text-blue-100 text-xs sm:text-sm">Department: <strong class="break-words"><?php echo e(auth()->user()->department->name); ?></strong></span>
                    <?php endif; ?>
                </div>
            </div>
            <div class="flex flex-col sm:flex-row gap-2 md:ml-4 w-full sm:w-auto">
                <a href="<?php echo e(route('trainer.submissions.index')); ?>" class="inline-flex items-center justify-center px-4 py-2 bg-white bg-opacity-20 hover:bg-opacity-30 text-white font-medium rounded-md transition-all border border-white border-opacity-30 text-sm sm:text-base">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                    </svg>
                    View Submissions
                </a>
                <a href="<?php echo e(route('trainer.marks.index')); ?>" class="inline-flex items-center justify-center px-4 py-2 bg-white bg-opacity-20 hover:bg-opacity-30 text-white font-medium rounded-md transition-all border border-white border-opacity-30 text-sm sm:text-base">
                    <svg class="w-4 h-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4M7.835 4.697a3.42 3.42 0 001.946-.806 3.42 3.42 0 014.438 0 3.42 3.42 0 001.946.806 3.42 3.42 0 013.138 3.138 3.42 3.42 0 00.806 1.946 3.42 3.42 0 010 4.438 3.42 3.42 0 00-.806 1.946 3.42 3.42 0 01-3.138 3.138 3.42 3.42 0 00-1.946.806 3.42 3.42 0 01-4.438 0 3.42 3.42 0 00-1.946-.806 3.42 3.42 0 01-3.138-3.138 3.42 3.42 0 00-.806-1.946 3.42 3.42 0 010-4.438 3.42 3.42 0 00.806-1.946 3.42 3.42 0 013.138-3.138z"></path>
                    </svg>
                    Enter Marks
                </a>
            </div>
        </div>
    </div>

    <!-- Deadline Alert for Pending Submissions -->
    <?php if($overdueSubmissionsCount > 0): ?>
        <div class="bg-red-50 border-l-4 border-red-500 p-4 rounded-lg">
            <div class="flex flex-col sm:flex-row sm:items-center gap-3">
                <div class="flex items-start sm:items-center flex-1 min-w-0">
                    <svg class="w-5 h-5 text-red-600 mr-2 flex-shrink-0 mt-0.5 sm:mt-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 9v2m0 4h.01m-6.938 4h13.856c1.54 0 2.502-1.667 1.732-3L13.732 4c-.77-1.333-2.694-1.333-3.464 0L3.34 16c-.77 1.333.192 3 1.732 3z"></path>
                    </svg>
                    <div class="min-w-0">
                        <p class="text-sm font-medium text-red-800">
                            🔴 <?php echo e($overdueSubmissionsCount); ?> <?php echo e(Str::plural('submission', $overdueSubmissionsCount)); ?> <?php echo e($overdueSubmissionsCount > 1 ? 'are' : 'is'); ?> overdue (more than 3 days)
                        </p>
                        <p class="text-xs text-red-600 mt-1">Please follow up on these submissions as soon as possible.</p>
                    </div>
                </div>
                <a href="<?php echo e(route('trainer.submissions.index')); ?>" class="sm:ml-4 inline-flex items-center justify-center min-h-[44px] px-4 py-2 text-sm font-medium text-red-800 hover:text-red-900 underline touch-manipulation">
                    View Submissions →
                </a>
            </div>
        </div>
    <?php endif; ?>

    <!-- Statistics Cards with Improved Labels -->
    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4 sm:gap-6">
        <!-- Submissions This Term -->
        <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 hover:shadow-lg transition-shadow cursor-pointer" onclick="window.location='<?php echo e(route('trainer.submissions.index')); ?>'">
            <div class="flex items-center justify-between">
                <div class="flex-1 min-w-0">
                    <p class="text-xs sm:text-sm font-medium text-gray-600 flex items-center">
                        <svg class="w-3 h-3 sm:w-4 sm:h-4 mr-1.5 text-blue-500 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                        <span class="truncate">Submissions This Term</span>
                    </p>
                    <p class="text-2xl sm:text-3xl font-bold text-gray-900 mt-2"><?php echo e($stats['total_submissions'] ?? 0); ?></p>
                </div>
                <div class="h-10 w-10 sm:h-12 sm:w-12 bg-blue-100 rounded-full flex items-center justify-center flex-shrink-0 ml-2">
                    <svg class="h-5 w-5 sm:h-6 sm:w-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <!-- Pending Submissions -->
        <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 hover:shadow-lg transition-shadow cursor-pointer" onclick="window.location='<?php echo e(route('trainer.submissions.index')); ?>'">
            <div class="flex items-center justify-between">
                <div class="flex-1 min-w-0">
                    <p class="text-xs sm:text-sm font-medium text-gray-600 flex items-center">
                        <svg class="w-3 h-3 sm:w-4 sm:h-4 mr-1.5 text-yellow-500 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <span class="truncate">Pending Submissions</span>
                    </p>
                    <p class="text-2xl sm:text-3xl font-bold text-yellow-600 mt-2"><?php echo e($stats['pending_submissions'] ?? 0); ?></p>
                </div>
                <div class="h-10 w-10 sm:h-12 sm:w-12 bg-yellow-100 rounded-full flex items-center justify-center flex-shrink-0 ml-2">
                    <svg class="h-5 w-5 sm:h-6 sm:w-6 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <!-- Marked by Me -->
        <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 hover:shadow-lg transition-shadow cursor-pointer" onclick="window.location='<?php echo e(route('trainer.marks.index')); ?>'">
            <div class="flex items-center justify-between">
                <div class="flex-1 min-w-0">
                    <p class="text-xs sm:text-sm font-medium text-gray-600 flex items-center">
                        <svg class="w-3 h-3 sm:w-4 sm:h-4 mr-1.5 text-purple-500 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        <span class="truncate">Marked by Me</span>
                    </p>
                    <p class="text-2xl sm:text-3xl font-bold text-purple-600 mt-2"><?php echo e($stats['reviewed_by_me'] ?? 0); ?></p>
                </div>
                <div class="h-10 w-10 sm:h-12 sm:w-12 bg-purple-100 rounded-full flex items-center justify-center flex-shrink-0 ml-2">
                    <svg class="h-5 w-5 sm:h-6 sm:w-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
            </div>
        </div>

        <!-- My Students -->
        <div class="bg-white rounded-lg shadow-md p-4 sm:p-6 hover:shadow-lg transition-shadow">
            <div class="flex items-center justify-between">
                <div class="flex-1 min-w-0">
                    <p class="text-xs sm:text-sm font-medium text-gray-600 flex items-center">
                        <svg class="w-3 h-3 sm:w-4 sm:h-4 mr-1.5 text-indigo-500 flex-shrink-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                        </svg>
                        <span class="truncate">My Students</span>
                    </p>
                    <p class="text-2xl sm:text-3xl font-bold text-indigo-600 mt-2"><?php echo e($totalStudents ?? 0); ?></p>
                </div>
                <div class="h-10 w-10 sm:h-12 sm:w-12 bg-indigo-100 rounded-full flex items-center justify-center flex-shrink-0 ml-2">
                    <svg class="h-5 w-5 sm:h-6 sm:w-6 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                    </svg>
                </div>
            </div>
        </div>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-4 sm:gap-6">
        <!-- Assigned Units with Quick Actions -->
        <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-lg font-semibold text-gray-900">My Units</h2>
                <span class="px-3 py-1 text-sm font-medium bg-blue-100 text-blue-800 rounded-full">
                    <?php echo e($assignedUnits->count()); ?> units
                </span>
            </div>
            <?php if($assignedUnits->count() > 0): ?>
                <div class="space-y-3">
                    <?php $__currentLoopData = $assignedUnits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="border border-gray-200 rounded-lg p-3 sm:p-4 hover:bg-gray-50 transition-colors">
                            <div class="flex items-start justify-between mb-3">
                                <div class="flex-1 min-w-0">
                                    <a href="<?php echo e(route('trainer.units.show', $unit)); ?>" class="block">
                                        <h3 class="font-semibold text-gray-900 hover:text-blue-600 truncate"><?php echo e($unit->name); ?></h3>
                                    </a>
                                    <?php if($unit->code): ?>
                                        <p class="text-xs sm:text-sm text-gray-500 mt-1">Code: <?php echo e($unit->code); ?></p>
                                    <?php endif; ?>
                                    <?php if($unit->department): ?>
                                        <p class="text-xs sm:text-sm text-gray-500 truncate"><?php echo e($unit->department->name); ?></p>
                                    <?php endif; ?>
                                    <div class="flex flex-wrap gap-1.5 sm:gap-2 mt-2">
                                        <span class="px-2 py-1 text-xs bg-gray-100 text-gray-800 rounded"><?php echo e($unit->students_count); ?> students</span>
                                        <span class="px-2 py-1 text-xs bg-blue-100 text-blue-800 rounded"><?php echo e($unit->submissions_count); ?> submissions</span>
                                        <span class="px-2 py-1 text-xs bg-purple-100 text-purple-800 rounded"><?php echo e($unit->assignments_count); ?> assignments</span>
                                        <?php if($unit->pending_submissions_count > 0): ?>
                                            <span class="px-2 py-1 text-xs bg-red-100 text-red-800 rounded font-semibold"><?php echo e($unit->pending_submissions_count); ?> pending</span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="flex flex-col sm:flex-row gap-2 mt-3 pt-3 border-t border-gray-200">
                                <a href="<?php echo e(route('trainer.units.show', $unit)); ?>" class="inline-flex items-center justify-center px-3 py-2 text-xs font-medium text-blue-700 bg-blue-50 hover:bg-blue-100 rounded-md transition-colors">
                                    <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                    </svg>
                                    View Unit
                                </a>
                                <a href="<?php echo e(route('trainer.submissions.index', ['unit' => $unit->id])); ?>" class="inline-flex items-center justify-center px-3 py-2 text-xs font-medium text-green-700 bg-green-50 hover:bg-green-100 rounded-md transition-colors">
                                    <svg class="w-3 h-3 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                    </svg>
                                    Submissions
                                </a>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="text-center py-8">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                    <h3 class="mt-2 text-sm font-medium text-gray-900">No units assigned</h3>
                    <p class="mt-1 text-sm text-gray-500">You don't have any units assigned for the active term.</p>
                </div>
            <?php endif; ?>
        </div>

        <!-- Pending Submissions Widget with Days Overdue -->
        <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
            <div class="flex items-center justify-between mb-4">
                <h2 class="text-lg font-semibold text-gray-900">Pending Submissions</h2>
                <a href="<?php echo e(route('trainer.submissions.index')); ?>" class="text-sm text-blue-600 hover:text-blue-800 font-medium">View All →</a>
            </div>
            <?php if(isset($pendingSubmissions) && $pendingSubmissions->count() > 0): ?>
                <div class="space-y-3">
                    <?php $__currentLoopData = $pendingSubmissions->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="border-l-4 <?php echo e($submission->is_overdue ? 'border-red-500 bg-red-50' : 'border-yellow-500 bg-yellow-50'); ?> p-3 rounded hover:shadow-sm transition-shadow">
                            <div class="flex items-start justify-between">
                                <div class="flex-1">
                                    <p class="text-sm font-medium text-gray-900"><?php echo e($submission->student->name); ?></p>
                                    <p class="text-xs text-gray-600 mt-0.5"><?php echo e($submission->unit->name); ?></p>
                                    <div class="flex items-center gap-2 mt-1.5">
                                        <span class="text-xs text-gray-500"><?php echo e($submission->schoolClass->name); ?></span>
                                        <?php if($submission->days_since_submission !== null): ?>
                                            <span class="text-xs font-medium <?php echo e($submission->is_overdue ? 'text-red-700' : 'text-yellow-700'); ?>">
                                                <?php if($submission->is_overdue): ?>
                                                    <?php echo e($submission->days_since_submission); ?> days overdue
                                                <?php else: ?>
                                                    <?php echo e($submission->days_since_submission); ?> day<?php echo e($submission->days_since_submission != 1 ? 's' : ''); ?> ago
                                                <?php endif; ?>
                                            </span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="text-right ml-3">
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-yellow-100 text-yellow-800">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $submission->status))); ?>

                                    </span>
                                </div>
                            </div>
                            <div class="mt-2">
                                <a href="<?php echo e(route('trainer.submissions.show', $submission)); ?>" class="inline-flex items-center text-xs text-blue-600 hover:text-blue-800 font-medium">
                                    View Submission
                                    <svg class="w-3 h-3 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <div class="text-center py-8">
                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <h3 class="mt-2 text-sm font-medium text-gray-900">No pending submissions</h3>
                    <p class="mt-1 text-sm text-gray-500">All submissions are up to date.</p>
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Student Performance Overview -->
    <?php if(count($studentPerformance) > 0): ?>
        <div class="bg-white rounded-lg shadow-md p-4 sm:p-6">
            <h2 class="text-base sm:text-lg font-semibold text-gray-900 mb-4">Student Performance Overview</h2>
            <div class="overflow-x-auto -mx-4 sm:mx-0">
                <div class="inline-block min-w-full align-middle">
                    <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Student</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Total Submissions</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Approved</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Average Marks</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php $__currentLoopData = $studentPerformance; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $performance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr class="hover:bg-gray-50 transition-colors">
                                <td class="px-4 py-4 whitespace-nowrap">
                                    <div class="text-sm font-medium text-gray-900"><?php echo e($performance['student']->name); ?></div>
                                    <div class="text-sm text-gray-500"><?php echo e($performance['student']->email); ?></div>
                                </td>
                                <td class="px-4 py-4 whitespace-nowrap text-sm text-gray-900">
                                    <?php echo e($performance['total_submissions']); ?>

                                </td>
                                <td class="px-4 py-4 whitespace-nowrap text-sm text-gray-900">
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">
                                        <?php echo e($performance['approved_submissions']); ?>

                                    </span>
                                </td>
                                <td class="px-4 py-4 whitespace-nowrap text-sm text-gray-900">
                                    <?php if($performance['average_marks'] > 0): ?>
                                        <span class="font-semibold"><?php echo e(number_format($performance['average_marks'], 1)); ?></span>
                                    <?php else: ?>
                                        <span class="text-gray-400">-</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    </table>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.trainer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/trainer/dashboard.blade.php ENDPATH**/ ?>