<?php $__env->startSection('title', 'PoE Submissions'); ?>
<?php $__env->startSection('page-title', 'Portfolio of Evidence Submissions'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-6 flex flex-col sm:flex-row sm:items-center sm:justify-between">
        <div>
            <h1 class="text-2xl font-bold text-gray-900">PoE Submissions</h1>
            <p class="mt-1 text-sm text-gray-600">Manage and track all portfolio submissions</p>
        </div>
    </div>

    <!-- Statistics Cards -->
    <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-9 gap-4 mb-6">
        <a href="<?php echo e(route('admin.submissions.index', ['status' => ''])); ?>" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">Total</p>
                <p class="text-2xl font-bold text-gray-900"><?php echo e($stats['total']); ?></p>
            </div>
        </a>
        <a href="<?php echo e(route('admin.submissions.index', ['status' => 'draft'])); ?>" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">Draft</p>
                <p class="text-2xl font-bold text-gray-500"><?php echo e($stats['draft']); ?></p>
            </div>
        </a>
        <a href="<?php echo e(route('admin.submissions.index', ['status' => 'submitted'])); ?>" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">Submitted</p>
                <p class="text-2xl font-bold text-blue-600"><?php echo e($stats['submitted']); ?></p>
            </div>
        </a>
        <a href="<?php echo e(route('admin.submissions.index', ['status' => 'under_review'])); ?>" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">Under Review</p>
                <p class="text-2xl font-bold text-yellow-600"><?php echo e($stats['under_review']); ?></p>
            </div>
        </a>
        <a href="<?php echo e(route('admin.submissions.index', ['status' => 'trainer_reviewed'])); ?>" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">Trainer Reviewed</p>
                <p class="text-2xl font-bold text-purple-600"><?php echo e($stats['trainer_reviewed']); ?></p>
            </div>
        </a>
        <a href="<?php echo e(route('admin.submissions.index', ['status' => 'hod_approved'])); ?>" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">HOD Approved</p>
                <p class="text-2xl font-bold text-indigo-600"><?php echo e($stats['hod_approved']); ?></p>
            </div>
        </a>
        <a href="<?php echo e(route('admin.submissions.index', ['status' => 'exams_verified'])); ?>" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">Exams Verified</p>
                <p class="text-2xl font-bold text-cyan-600"><?php echo e($stats['exams_verified']); ?></p>
            </div>
        </a>
        <a href="<?php echo e(route('admin.submissions.index', ['status' => 'validator_approved'])); ?>" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">Validated</p>
                <p class="text-2xl font-bold text-green-600"><?php echo e($stats['validator_approved']); ?></p>
            </div>
        </a>
        <a href="<?php echo e(route('admin.submissions.index', ['status' => 'rejected'])); ?>" class="bg-white rounded-lg shadow p-4 hover:shadow-md transition-shadow">
            <div class="text-center">
                <p class="text-sm font-medium text-gray-600">Rejected</p>
                <p class="text-2xl font-bold text-red-600"><?php echo e($stats['rejected']); ?></p>
            </div>
        </a>
    </div>

    <!-- Filters -->
    <div class="bg-white rounded-lg shadow-sm p-6 mb-6">
        <form method="GET" action="<?php echo e(route('admin.submissions.index')); ?>" class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-4 gap-4">
            <div>
                <label for="term" class="block text-sm font-medium text-gray-700 mb-1">Term</label>
                <select name="term" id="term" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">All Terms</option>
                    <?php $__currentLoopData = $filterOptions['terms']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $term): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($term->id); ?>" <?php echo e(request('term') == $term->id ? 'selected' : ''); ?>>
                            <?php echo e($term->name); ?> <?php if($term->status === 'active'): ?>(Active)<?php endif; ?>
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div>
                <label for="department" class="block text-sm font-medium text-gray-700 mb-1">Department</label>
                <select name="department" id="department" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">All Departments</option>
                    <?php $__currentLoopData = $filterOptions['departments']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($department->id); ?>" <?php echo e(request('department') == $department->id ? 'selected' : ''); ?>>
                            <?php echo e($department->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div>
                <label for="level" class="block text-sm font-medium text-gray-700 mb-1">Level</label>
                <select name="level" id="level" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">All Levels</option>
                    <?php $__currentLoopData = $filterOptions['levels']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($level->id); ?>" <?php echo e(request('level') == $level->id ? 'selected' : ''); ?>>
                            <?php echo e($level->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div>
                <label for="class" class="block text-sm font-medium text-gray-700 mb-1">Class</label>
                <select name="class" id="class" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">All Classes</option>
                    <?php $__currentLoopData = $filterOptions['classes']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($class->id); ?>" <?php echo e(request('class') == $class->id ? 'selected' : ''); ?>>
                            <?php echo e($class->name); ?> <?php if(isset($class->department)): ?> (<?php echo e($class->department->name); ?>) <?php endif; ?>
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div>
                <label for="unit" class="block text-sm font-medium text-gray-700 mb-1">Unit</label>
                <select name="unit" id="unit" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">All Units</option>
                    <?php $__currentLoopData = $filterOptions['units']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($unit->id); ?>" <?php echo e(request('unit') == $unit->id ? 'selected' : ''); ?>>
                            <?php echo e($unit->code); ?> - <?php echo e($unit->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div>
                <label for="status" class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                <select name="status" id="status" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">All Statuses</option>
                    <option value="draft" <?php echo e(request('status') == 'draft' ? 'selected' : ''); ?>>Draft</option>
                    <option value="submitted" <?php echo e(request('status') == 'submitted' ? 'selected' : ''); ?>>Submitted</option>
                    <option value="under_review" <?php echo e(request('status') == 'under_review' ? 'selected' : ''); ?>>Under Review</option>
                    <option value="trainer_reviewed" <?php echo e(request('status') == 'trainer_reviewed' ? 'selected' : ''); ?>>Trainer Reviewed</option>
                    <option value="hod_approved" <?php echo e(request('status') == 'hod_approved' ? 'selected' : ''); ?>>HOD Approved</option>
                    <option value="exams_verified" <?php echo e(request('status') == 'exams_verified' ? 'selected' : ''); ?>>Exams Verified</option>
                    <option value="validator_approved" <?php echo e(request('status') == 'validator_approved' ? 'selected' : ''); ?>>Validator Approved</option>
                    <option value="rejected" <?php echo e(request('status') == 'rejected' ? 'selected' : ''); ?>>Rejected</option>
                </select>
            </div>
            <div>
                <label for="student" class="block text-sm font-medium text-gray-700 mb-1">Student</label>
                <select name="student" id="student" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    <option value="">All Students</option>
                    <?php $__currentLoopData = $filterOptions['students']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($student->id); ?>" <?php echo e(request('student') == $student->id ? 'selected' : ''); ?>>
                            <?php echo e($student->name); ?> (<?php echo e($student->email); ?>)
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div>
                <label for="search" class="block text-sm font-medium text-gray-700 mb-1">Search</label>
                <input type="text" name="search" id="search" value="<?php echo e(request('search')); ?>" placeholder="Student, Unit..." class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            </div>
            <div class="md:col-span-3 lg:col-span-4 flex gap-2">
                <button type="submit" class="px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700">Filter</button>
                <a href="<?php echo e(route('admin.submissions.index')); ?>" class="px-4 py-2 bg-gray-200 text-gray-700 rounded-md hover:bg-gray-300">Clear</a>
            </div>
        </form>
    </div>

    <!-- Active Term Banner -->
    <?php if($activeTerm): ?>
        <div class="bg-indigo-50 border-l-4 border-indigo-500 p-4 mb-6 rounded">
            <div class="flex">
                <div class="flex-shrink-0">
                    <svg class="h-5 w-5 text-indigo-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"/>
                    </svg>
                </div>
                <div class="ml-3">
                    <p class="text-sm text-indigo-700">
                        <strong>Active Term:</strong> <?php echo e($activeTerm->name); ?> 
                        (<?php echo e($activeTerm->start_date->format('M d, Y')); ?> - <?php echo e($activeTerm->end_date->format('M d, Y')); ?>)
                    </p>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <!-- Submissions Table -->
    <div class="bg-white shadow-sm rounded-lg overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Student</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Unit</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Class</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Version</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Evidence</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Submitted</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__empty_1 = true; $__currentLoopData = $submissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="flex items-center">
                                    <div class="h-10 w-10 rounded-full bg-indigo-600 flex items-center justify-center">
                                        <span class="text-white font-semibold text-sm"><?php echo e(substr($submission->student->name, 0, 1)); ?></span>
                                    </div>
                                    <div class="ml-4">
                                        <div class="text-sm font-medium text-gray-900"><?php echo e($submission->student->name); ?></div>
                                        <div class="text-sm text-gray-500"><?php echo e($submission->student->email); ?></div>
                                    </div>
                                </div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-sm font-medium text-gray-900"><?php echo e($submission->unit->code); ?></div>
                                <div class="text-sm text-gray-500"><?php echo e(Str::limit($submission->unit->name, 40)); ?></div>
                            </td>
                            <td class="px-6 py-4">
                                <div class="text-sm font-medium text-gray-900"><?php echo e($submission->schoolClass->name); ?></div>
                                <div class="text-sm text-gray-500"><?php echo e($submission->schoolClass->department->name); ?></div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <span class="px-2 py-1 text-xs font-semibold rounded-full
                                    <?php if($submission->status === 'draft'): ?> bg-gray-100 text-gray-800
                                    <?php elseif($submission->status === 'submitted'): ?> bg-blue-100 text-blue-800
                                    <?php elseif($submission->status === 'under_review'): ?> bg-yellow-100 text-yellow-800
                                    <?php elseif($submission->status === 'trainer_reviewed'): ?> bg-purple-100 text-purple-800
                                    <?php elseif($submission->status === 'hod_approved'): ?> bg-indigo-100 text-indigo-800
                                    <?php elseif($submission->status === 'exams_verified'): ?> bg-cyan-100 text-cyan-800
                                    <?php elseif($submission->status === 'validator_approved'): ?> bg-green-100 text-green-800
                                    <?php else: ?> bg-red-100 text-red-800
                                    <?php endif; ?>">
                                    <?php echo e(str_replace('_', ' ', ucfirst($submission->status))); ?>

                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                v<?php echo e($submission->version); ?>

                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                <span class="inline-flex items-center">
                                    <svg class="h-4 w-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                    </svg>
                                    <?php echo e($submission->evidence_count); ?> file(s)
                                </span>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                <?php if($submission->submitted_at): ?>
                                    <?php echo e($submission->submitted_at->format('M d, Y')); ?>

                                    <div class="text-xs text-gray-400"><?php echo e($submission->submitted_at->format('h:i A')); ?></div>
                                <?php else: ?>
                                    <span class="text-gray-400">Not submitted</span>
                                <?php endif; ?>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <a href="<?php echo e(route('admin.submissions.show', $submission)); ?>" class="text-indigo-600 hover:text-indigo-900">View</a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="8" class="px-6 py-12 text-center text-gray-500">
                                <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                </svg>
                                <p class="mt-2">No submissions found</p>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <div class="bg-white px-4 py-3 border-t border-gray-200 sm:px-6">
            <?php echo e($submissions->links()); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/admin/submissions/index.blade.php ENDPATH**/ ?>