

<?php $__env->startSection('title', 'Create Unit Allocation'); ?>
<?php $__env->startSection('page-title', 'Create Unit Allocation'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-6">
        <a href="<?php echo e(route('admin.unit-allocations.index')); ?>" class="text-indigo-600 hover:text-indigo-900">
            ← Back to Allocations
        </a>
    </div>

    <div class="bg-white shadow rounded-lg p-6">
        <h2 class="text-xl font-semibold text-gray-900 mb-6">Assign Trainer to Unit in Class</h2>

        <?php if($errors->any()): ?>
            <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                <strong class="font-bold">Validation Errors:</strong>
                <ul class="list-disc list-inside mt-2">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="mb-4 bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative" role="alert">
                <strong class="font-bold">Error:</strong>
                <span class="block sm:inline"><?php echo e(session('error')); ?></span>
            </div>
        <?php endif; ?>

        <?php if($activeTerm): ?>
            <div class="mb-4 bg-blue-50 border border-blue-200 text-blue-800 px-4 py-3 rounded">
                <p class="text-sm"><strong>Active Term:</strong> <?php echo e($activeTerm->name); ?> (<?php echo e($activeTerm->start_date->format('M d, Y')); ?> - <?php echo e($activeTerm->end_date->format('M d, Y')); ?>)</p>
            </div>
        <?php else: ?>
            <div class="mb-4 bg-yellow-50 border border-yellow-200 text-yellow-800 px-4 py-3 rounded">
                <p class="text-sm"><strong>Warning:</strong> No active term found. Please activate a term first.</p>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('admin.unit-allocations.store')); ?>" method="POST" x-data="{
            selectedDepartment: '<?php echo e(old('department_id', $selectedDepartment ?? '')); ?>',
            selectedClass: '<?php echo e(old('class_id', $selectedClass ?? '')); ?>',
            selectedTrainer: '<?php echo e(old('trainer_id', $selectedTrainer ?? '')); ?>',
            selectedUnits: <?php echo \Illuminate\Support\Js::from(old('unit_ids', []))->toHtml() ?>,
            classes: <?php echo \Illuminate\Support\Js::from($classes->map(function($class) {
                return [
                    'id' => $class->id,
                    'name' => $class->name,
                    'code' => $class->code,
                    'department_id' => $class->department_id,
                ];
            })->toArray())->toHtml() ?>,
            trainers: <?php echo \Illuminate\Support\Js::from($trainers->map(function($trainer) {
                return [
                    'id' => $trainer->id,
                    'name' => $trainer->name,
                    'email' => $trainer->email,
                    'department_id' => $trainer->department_id,
                ];
            })->toArray())->toHtml() ?>,
            units: <?php echo \Illuminate\Support\Js::from($units->map(function($unit) {
                return [
                    'id' => $unit->id,
                    'name' => $unit->name,
                    'code' => $unit->code,
                    'department_id' => $unit->department_id,
                    'class_ids' => $unit->classes->pluck('id')->toArray(),
                ];
            })->toArray())->toHtml() ?>,
            get filteredClasses() {
                if (!this.selectedDepartment) return [];
                return this.classes.filter(c => c.department_id == this.selectedDepartment);
            },
            get filteredTrainers() {
                if (!this.selectedDepartment) return [];
                return this.trainers.filter(t => t.department_id == this.selectedDepartment);
            },
            get filteredUnits() {
                if (!this.selectedClass || !this.selectedDepartment) return [];
                // Get units that are in the selected department AND assigned to the selected class
                return this.units.filter(u => 
                    u.department_id == this.selectedDepartment && 
                    u.class_ids.includes(parseInt(this.selectedClass))
                );
            },
            toggleUnit(unitId) {
                const index = this.selectedUnits.indexOf(unitId);
                if (index > -1) {
                    this.selectedUnits.splice(index, 1);
                } else {
                    this.selectedUnits.push(unitId);
                }
            },
            isUnitSelected(unitId) {
                return this.selectedUnits.includes(unitId);
            },
            init() {
                this.$watch('selectedDepartment', (newDept, oldDept) => {
                    if (newDept !== oldDept) {
                        this.selectedClass = '';
                        this.selectedTrainer = '';
                        this.selectedUnits = [];
                    }
                });
                this.$watch('selectedClass', (newClass, oldClass) => {
                    if (newClass !== oldClass) {
                        this.selectedUnits = [];
                    }
                });
            }
        }">
            <?php echo csrf_field(); ?>

            <div class="space-y-6">
                <!-- Department Selection -->
                <div>
                    <label for="department_id" class="block text-sm font-medium text-gray-700 mb-2">Department <span class="text-red-500">*</span></label>
                    <select id="department_id" 
                            name="department_id" 
                            x-model="selectedDepartment"
                            class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                            required>
                        <option value="">Select a department</option>
                        <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($department->id); ?>" <?php echo e(old('department_id', $selectedDepartment ?? '') == $department->id ? 'selected' : ''); ?>>
                                <?php echo e($department->name); ?>

                                <?php if($department->code): ?>
                                    (<?php echo e($department->code); ?>)
                                <?php endif; ?>
                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <p class="mt-1 text-xs text-gray-500">Select the department to filter classes, trainers, and units</p>
                </div>

                <!-- Class Selection -->
                <div>
                    <label for="class_id" class="block text-sm font-medium text-gray-700 mb-2">Class <span class="text-red-500">*</span></label>
                    <select id="class_id" 
                            name="class_id" 
                            x-model="selectedClass"
                            class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 disabled:bg-gray-100 disabled:cursor-not-allowed"
                            :disabled="!selectedDepartment || filteredClasses.length === 0"
                            required>
                        <option value="">Select a class</option>
                        <template x-for="classItem in filteredClasses" :key="classItem.id">
                            <option :value="classItem.id" x-text="classItem.name + (classItem.code ? ' (' + classItem.code + ')' : '')"></option>
                        </template>
                    </select>
                    <p class="mt-1 text-xs text-gray-500" x-show="!selectedDepartment">
                        Please select a department first
                    </p>
                    <p class="mt-1 text-xs text-red-600" x-show="selectedDepartment && filteredClasses.length === 0">
                        No classes available for this department in the active term
                    </p>
                </div>

                <!-- Trainer Selection -->
                <div>
                    <label for="trainer_id" class="block text-sm font-medium text-gray-700 mb-2">Trainer <span class="text-red-500">*</span></label>
                    <select id="trainer_id" 
                            name="trainer_id" 
                            x-model="selectedTrainer"
                            class="block w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 disabled:bg-gray-100 disabled:cursor-not-allowed"
                            :disabled="!selectedDepartment || filteredTrainers.length === 0"
                            required>
                        <option value="">Select a trainer</option>
                        <template x-for="trainer in filteredTrainers" :key="trainer.id">
                            <option :value="trainer.id" x-text="trainer.name + ' (' + trainer.email + ')'"></option>
                        </template>
                    </select>
                    <p class="mt-1 text-xs text-gray-500" x-show="!selectedDepartment">
                        Please select a department first
                    </p>
                    <p class="mt-1 text-xs text-red-600" x-show="selectedDepartment && filteredTrainers.length === 0">
                        No active trainers available in this department
                    </p>
                </div>

                <!-- Unit Selection (Multiple) -->
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">
                        Units <span class="text-red-500">*</span>
                        <span class="text-xs font-normal text-gray-500 ml-2">(Select one or more units)</span>
                    </label>
                    <div x-show="!selectedDepartment || !selectedClass" class="text-xs text-gray-500 mb-2">
                        Please select a department and class first
                    </div>
                    <div x-show="selectedDepartment && selectedClass && filteredUnits.length === 0" class="text-xs text-red-600 mb-2">
                        No units available in this department for the selected class. Make sure units are assigned to the class.
                    </div>
                    <div x-show="selectedDepartment && selectedClass && filteredUnits.length > 0" 
                         class="max-h-60 overflow-y-auto border border-gray-300 rounded-md bg-white p-4">
                        <div class="space-y-2">
                            <template x-for="unit in filteredUnits" :key="unit.id">
                                <label class="flex items-center space-x-3 p-2 hover:bg-gray-50 rounded cursor-pointer">
                                    <input type="checkbox" 
                                           :value="unit.id"
                                           :checked="isUnitSelected(unit.id)"
                                           @change="toggleUnit(unit.id)"
                                           name="unit_ids[]"
                                           class="rounded border-gray-300 text-indigo-600 focus:ring-indigo-500">
                                    <span class="text-sm text-gray-700">
                                        <span x-text="unit.name"></span>
                                        <span x-show="unit.code" class="text-gray-500"> (<span x-text="unit.code"></span>)</span>
                                    </span>
                                </label>
                            </template>
                        </div>
                    </div>
                    <p class="mt-2 text-xs text-gray-500" x-show="selectedDepartment && selectedClass && filteredUnits.length > 0">
                        <span x-text="selectedUnits.length"></span> unit(s) selected
                    </p>
                </div>

                <!-- Validation Rules Info -->
                <div class="bg-gray-50 border border-gray-200 rounded-md p-4">
                    <h3 class="text-sm font-semibold text-gray-900 mb-2">Validation Rules:</h3>
                    <ul class="text-xs text-gray-600 space-y-1 list-disc list-inside">
                        <li>Units must be assigned to the selected class</li>
                        <li>The trainer and units must be in the same department</li>
                        <li>A class cannot have the same unit assigned twice</li>
                        <li>A trainer cannot be assigned the same unit in the same class twice</li>
                        <li>You can select multiple units to allocate at once</li>
                    </ul>
                </div>

                <!-- Submit Button -->
                <div class="flex justify-end space-x-3 pt-4 border-t">
                    <a href="<?php echo e(route('admin.unit-allocations.index')); ?>" class="px-4 py-2 border border-gray-300 rounded-md shadow-sm text-sm font-medium text-gray-700 bg-white hover:bg-gray-50">
                        Cancel
                    </a>
                    <button type="submit" class="px-4 py-2 border border-transparent rounded-md shadow-sm text-sm font-medium text-white bg-indigo-600 hover:bg-indigo-700">
                        Create Allocation
                    </button>
                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/admin/unit-allocations/create.blade.php ENDPATH**/ ?>