<?php $__env->startSection('title', 'Reports & Analytics'); ?>
<?php $__env->startSection('page-title', 'Reports & Analytics'); ?>

<?php $__env->startSection('content'); ?>
    <div class="mb-6">
        <h1 class="text-2xl font-bold text-gray-900">Reports & Analytics</h1>
        <p class="mt-1 text-sm text-gray-600">Generate comprehensive reports for submissions, students, classes, and departments</p>
    </div>

    <!-- Quick Stats -->
    <div class="grid grid-cols-1 md:grid-cols-4 gap-6 mb-6">
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Total Submissions</p>
                    <p class="text-2xl font-bold text-gray-900 mt-1"><?php echo e($quickStats['total_submissions']); ?></p>
                </div>
                <div class="h-12 w-12 bg-indigo-100 rounded-lg flex items-center justify-center">
                    <svg class="h-6 w-6 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Total Students</p>
                    <p class="text-2xl font-bold text-gray-900 mt-1"><?php echo e($quickStats['total_students']); ?></p>
                </div>
                <div class="h-12 w-12 bg-green-100 rounded-lg flex items-center justify-center">
                    <svg class="h-6 w-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197M13 7a4 4 0 11-8 0 4 4 0 018 0z"></path>
                    </svg>
                </div>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Total Classes</p>
                    <p class="text-2xl font-bold text-gray-900 mt-1"><?php echo e($quickStats['total_classes']); ?></p>
                </div>
                <div class="h-12 w-12 bg-purple-100 rounded-lg flex items-center justify-center">
                    <svg class="h-6 w-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path>
                    </svg>
                </div>
            </div>
        </div>
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium text-gray-600">Total Units</p>
                    <p class="text-2xl font-bold text-gray-900 mt-1"><?php echo e($quickStats['total_units']); ?></p>
                </div>
                <div class="h-12 w-12 bg-blue-100 rounded-lg flex items-center justify-center">
                    <svg class="h-6 w-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
            </div>
        </div>
    </div>

    <!-- Analytics Section -->
    <div class="bg-white rounded-lg shadow-sm p-6 mb-6">
        <h2 class="text-lg font-semibold text-gray-900 mb-4">Analytics Overview</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <!-- Submission Status Chart -->
            <div>
                <h3 class="text-sm font-medium text-gray-700 mb-3">Submissions by Status</h3>
                <div class="space-y-2">
                    <?php
                        $statusCounts = [
                            'draft' => \App\Models\PoeSubmission::where('status', 'draft')->count(),
                            'submitted' => \App\Models\PoeSubmission::where('status', 'submitted')->count(),
                            'under_review' => \App\Models\PoeSubmission::where('status', 'under_review')->count(),
                            'trainer_reviewed' => \App\Models\PoeSubmission::where('status', 'trainer_reviewed')->count(),
                            'hod_approved' => \App\Models\PoeSubmission::where('status', 'hod_approved')->count(),
                            'exams_verified' => \App\Models\PoeSubmission::where('status', 'exams_verified')->count(),
                            'validator_approved' => \App\Models\PoeSubmission::where('status', 'validator_approved')->count(),
                            'rejected' => \App\Models\PoeSubmission::where('status', 'rejected')->count(),
                        ];
                        $total = array_sum($statusCounts);
                    ?>
                    <?php $__currentLoopData = $statusCounts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status => $count): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($count > 0): ?>
                            <div class="flex items-center">
                                <div class="w-24 text-xs text-gray-600 truncate"><?php echo e(ucfirst(str_replace('_', ' ', $status))); ?></div>
                                <div class="flex-1 mx-2">
                                    <div class="w-full bg-gray-200 rounded-full h-4">
                                        <div class="bg-indigo-600 h-4 rounded-full" style="width: <?php echo e($total > 0 ? ($count / $total * 100) : 0); ?>%"></div>
                                    </div>
                                </div>
                                <div class="w-12 text-xs font-semibold text-gray-900 text-right"><?php echo e($count); ?></div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <!-- Submission Trends -->
            <div>
                <h3 class="text-sm font-medium text-gray-700 mb-3">Recent Activity</h3>
                <?php
                    $recentSubmissions = \App\Models\PoeSubmission::withoutGlobalScope('activeTerm')
                        ->where('poe_submissions.created_at', '>=', now()->subDays(30))
                        ->selectRaw('DATE(poe_submissions.created_at) as date, COUNT(*) as count')
                        ->groupBy('date')
                        ->orderBy('date', 'desc')
                        ->limit(7)
                        ->get();
                ?>
                <?php if($recentSubmissions->count() > 0): ?>
                    <div class="space-y-2">
                        <?php $__currentLoopData = $recentSubmissions->reverse(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="flex items-center">
                                <div class="w-20 text-xs text-gray-600"><?php echo e(\Carbon\Carbon::parse($day->date)->format('M d')); ?></div>
                                <div class="flex-1 mx-2">
                                    <div class="w-full bg-gray-200 rounded-full h-4">
                                        <div class="bg-green-600 h-4 rounded-full" style="width: <?php echo e(($day->count / $recentSubmissions->max('count')) * 100); ?>%"></div>
                                    </div>
                                </div>
                                <div class="w-8 text-xs font-semibold text-gray-900 text-right"><?php echo e($day->count); ?></div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <p class="text-sm text-gray-500">No recent activity</p>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Report Types -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <!-- Submissions Report -->
        <div class="bg-white rounded-lg shadow-sm overflow-hidden">
            <div class="p-6">
                <div class="flex items-center mb-4">
                    <div class="h-10 w-10 bg-indigo-100 rounded-lg flex items-center justify-center mr-3">
                        <svg class="h-6 w-6 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900">Submissions Report</h3>
                </div>
                <p class="text-sm text-gray-600 mb-4">Generate comprehensive reports on all PoE submissions with filters by term, department, level, class, and status.</p>
                <a href="#submissions-report" onclick="showReportForm('submissions')" class="inline-flex items-center px-4 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700">
                    Generate Report
                </a>
            </div>
        </div>

        <!-- Student Report -->
        <div class="bg-white rounded-lg shadow-sm overflow-hidden">
            <div class="p-6">
                <div class="flex items-center mb-4">
                    <div class="h-10 w-10 bg-green-100 rounded-lg flex items-center justify-center mr-3">
                        <svg class="h-6 w-6 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900">Student Report</h3>
                </div>
                <p class="text-sm text-gray-600 mb-4">Generate individual student reports showing all their submissions, progress, and performance for a specific term.</p>
                <a href="#student-report" onclick="showReportForm('student')" class="inline-flex items-center px-4 py-2 bg-green-600 text-white rounded-md hover:bg-green-700">
                    Generate Report
                </a>
            </div>
        </div>

        <!-- Class Report -->
        <div class="bg-white rounded-lg shadow-sm overflow-hidden">
            <div class="p-6">
                <div class="flex items-center mb-4">
                    <div class="h-10 w-10 bg-purple-100 rounded-lg flex items-center justify-center mr-3">
                        <svg class="h-6 w-6 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6.253v13m0-13C10.832 5.477 9.246 5 7.5 5S4.168 5.477 3 6.253v13C4.168 18.477 5.754 18 7.5 18s3.332.477 4.5 1.253m0-13C13.168 5.477 14.754 5 16.5 5c1.747 0 3.332.477 4.5 1.253v13C19.832 18.477 18.247 18 16.5 18c-1.746 0-3.332.477-4.5 1.253"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900">Class Report</h3>
                </div>
                <p class="text-sm text-gray-600 mb-4">Generate class-level reports showing all students, submissions, and performance metrics for a specific class.</p>
                <a href="#class-report" onclick="showReportForm('class')" class="inline-flex items-center px-4 py-2 bg-purple-600 text-white rounded-md hover:bg-purple-700">
                    Generate Report
                </a>
            </div>
        </div>

        <!-- Department Report -->
        <div class="bg-white rounded-lg shadow-sm overflow-hidden">
            <div class="p-6">
                <div class="flex items-center mb-4">
                    <div class="h-10 w-10 bg-blue-100 rounded-lg flex items-center justify-center mr-3">
                        <svg class="h-6 w-6 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 21V5a2 2 0 00-2-2H7a2 2 0 00-2 2v16m14 0h2m-2 0h-5m-9 0H3m2 0h5M9 7h1m-1 4h1m4-4h1m-1 4h1m-5 10v-5a1 1 0 011-1h2a1 1 0 011 1v5m-4 0h4"></path>
                        </svg>
                    </div>
                    <h3 class="text-lg font-semibold text-gray-900">Department Report</h3>
                </div>
                <p class="text-sm text-gray-600 mb-4">Generate department-wide reports showing all classes, students, submissions, and performance statistics.</p>
                <a href="#department-report" onclick="showReportForm('department')" class="inline-flex items-center px-4 py-2 bg-blue-600 text-white rounded-md hover:bg-blue-700">
                    Generate Report
                </a>
            </div>
        </div>
    </div>

        <!-- Report Forms (Hidden by default) -->
        <div id="report-forms" class="mt-8 space-y-6 hidden">
            <!-- Submissions Report Form -->
            <div id="submissions-form" class="bg-white rounded-lg shadow-sm p-6 hidden">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-lg font-semibold text-gray-900">Submissions Report</h3>
                    <button onclick="hideReportForms()" class="text-gray-400 hover:text-gray-600">
                        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                        </svg>
                    </button>
                </div>
            <h3 class="text-lg font-semibold text-gray-900 mb-4">Submissions Report</h3>
            <form action="<?php echo e(route('admin.reports.submissions')); ?>" method="GET" class="space-y-4">
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <label for="term_id" class="block text-sm font-medium text-gray-700 mb-1">Term</label>
                        <select name="term_id" id="term_id" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="">All Terms</option>
                            <?php $__currentLoopData = $terms; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $term): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($term->id); ?>"><?php echo e($term->name); ?> <?php if($term->status === 'active'): ?>(Active)<?php endif; ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div>
                        <label for="department_id" class="block text-sm font-medium text-gray-700 mb-1">Department</label>
                        <select name="department_id" id="department_id" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="">All Departments</option>
                            <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $dept): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($dept->id); ?>"><?php echo e($dept->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div>
                        <label for="status" class="block text-sm font-medium text-gray-700 mb-1">Status</label>
                        <select name="status" id="status" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="">All Statuses</option>
                            <option value="draft">Draft</option>
                            <option value="submitted">Submitted</option>
                            <option value="under_review">Under Review</option>
                            <option value="trainer_reviewed">Trainer Reviewed</option>
                            <option value="hod_approved">HOD Approved</option>
                            <option value="exams_verified">Exams Verified</option>
                            <option value="validator_approved">Validator Approved</option>
                            <option value="rejected">Rejected</option>
                        </select>
                    </div>
                </div>
                <div class="flex gap-4">
                    <div class="flex-1">
                        <label for="format" class="block text-sm font-medium text-gray-700 mb-1">Export Format</label>
                        <select name="format" id="format" class="w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" required>
                            <option value="html">View in Browser</option>
                            <option value="pdf">PDF Document</option>
                            <option value="excel">Excel Spreadsheet</option>
                        </select>
                    </div>
                    <div class="flex items-end">
                        <button type="submit" class="px-6 py-2 bg-indigo-600 text-white rounded-md hover:bg-indigo-700">Generate</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
function showReportForm(type) {
    document.getElementById('report-forms').classList.remove('hidden');
    document.querySelectorAll('#report-forms > div').forEach(form => form.classList.add('hidden'));
    const formId = type + '-form';
    if (document.getElementById(formId)) {
        document.getElementById(formId).classList.remove('hidden');
        document.getElementById('report-forms').scrollIntoView({ behavior: 'smooth' });
    } else {
        // For student, class, department reports - redirect to selection
        if (type === 'student') {
            window.location.href = '<?php echo e(route("admin.users.index", ["role" => "student"])); ?>';
        } else if (type === 'class') {
            window.location.href = '<?php echo e(route("admin.classes.index")); ?>';
        } else if (type === 'department') {
            window.location.href = '<?php echo e(route("admin.departments.index")); ?>';
        }
    }
}

function hideReportForms() {
    document.getElementById('report-forms').classList.add('hidden');
}
</script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/admin/reports/index.blade.php ENDPATH**/ ?>