<header class="bg-white shadow-sm border-b border-gray-200">
    <div class="flex items-center justify-between px-4 sm:px-6 lg:px-8 py-4">
        <div class="flex items-center">
            <h1 class="text-lg font-semibold text-gray-900"><?php echo $__env->yieldContent('header-title', 'Validator Portal'); ?></h1>
        </div>
        <div class="flex items-center space-x-4">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="h-8 w-8 rounded-full bg-indigo-600 flex items-center justify-center">
                        <span class="text-white font-semibold text-xs"><?php echo e(substr(auth()->user()->name, 0, 1)); ?></span>
                    </div>
                </div>
                <div class="ml-3">
                    <p class="text-sm font-medium text-gray-700"><?php echo e(auth()->user()->name); ?></p>
                    <p class="text-xs text-gray-500">Validator</p>
                </div>
            </div>
            
            <!-- Logout -->
            <form method="POST" action="<?php echo e(route('logout')); ?>">
                <?php echo csrf_field(); ?>
                <button type="submit" class="text-gray-500 hover:text-gray-700">
                    <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 16l4-4m0 0l-4-4m4 4H7m6 4v1a3 3 0 01-3 3H6a3 3 0 01-3-3V7a3 3 0 013-3h4a3 3 0 013 3v1"></path>
                    </svg>
                </button>
            </form>
        </div>
    </div>
</header>
<?php /**PATH D:\poe\resources\views/components/validator-header.blade.php ENDPATH**/ ?>