

<?php $__env->startSection('title', 'User Details'); ?>
<?php $__env->startSection('page-title', 'User Details'); ?>

<?php $__env->startSection('content'); ?>
<div class="space-y-6">
    <!-- Header -->
    <div class="bg-white rounded-xl shadow-md p-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-gray-900 mb-2">User Details</h1>
                <p class="text-gray-600">View user information and activity</p>
            </div>
            <div class="flex items-center gap-3">
                <a href="<?php echo e(route('hod.users.edit', $user)); ?>" class="bg-purple-600 text-white px-4 py-2 rounded-lg hover:bg-purple-700 transition-colors font-medium">
                    Edit User
                </a>
                <a href="<?php echo e(route('hod.users.index')); ?>" class="text-purple-600 hover:text-purple-800 font-medium">
                    ← Back to Users
                </a>
            </div>
        </div>
    </div>

    <!-- User Information -->
    <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <!-- Main Info -->
        <div class="lg:col-span-2 bg-white rounded-xl shadow-md p-6">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Personal Information</h2>
            <dl class="grid grid-cols-1 gap-4">
                <div>
                    <dt class="text-sm font-medium text-gray-500">Full Name</dt>
                    <dd class="mt-1 text-sm text-gray-900"><?php echo e($user->name); ?></dd>
                </div>
                <?php if($user->first_name): ?>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">First Name</dt>
                        <dd class="mt-1 text-sm text-gray-900"><?php echo e($user->first_name); ?></dd>
                    </div>
                <?php endif; ?>
                <?php if($user->last_name): ?>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Last Name</dt>
                        <dd class="mt-1 text-sm text-gray-900"><?php echo e($user->last_name); ?></dd>
                    </div>
                <?php endif; ?>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Email Address</dt>
                    <dd class="mt-1 text-sm text-gray-900"><?php echo e($user->email); ?></dd>
                    <?php if($user->email_verified_at): ?>
                        <span class="inline-flex items-center px-2 py-1 rounded-md text-xs font-medium bg-green-100 text-green-800 mt-1">
                            Verified
                        </span>
                    <?php else: ?>
                        <span class="inline-flex items-center px-2 py-1 rounded-md text-xs font-medium bg-yellow-100 text-yellow-800 mt-1">
                            Not Verified
                        </span>
                    <?php endif; ?>
                </div>
                <?php if($user->phone): ?>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Phone Number</dt>
                        <dd class="mt-1 text-sm text-gray-900"><?php echo e($user->phone); ?></dd>
                    </div>
                <?php endif; ?>
                <?php if($user->admission_number): ?>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Admission Number</dt>
                        <dd class="mt-1 text-sm text-gray-900"><?php echo e($user->admission_number); ?></dd>
                    </div>
                <?php endif; ?>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Role</dt>
                    <dd class="mt-1">
                        <span class="px-2 py-1 text-xs font-semibold rounded-full 
                            <?php if($user->role == 'trainer'): ?> bg-purple-100 text-purple-800
                            <?php elseif($user->role == 'validator'): ?> bg-yellow-100 text-yellow-800
                            <?php else: ?> bg-pink-100 text-pink-800
                            <?php endif; ?>">
                            <?php echo e(ucfirst(str_replace('_', ' ', $user->role))); ?>

                        </span>
                    </dd>
                </div>
                <?php if($user->department): ?>
                    <div>
                        <dt class="text-sm font-medium text-gray-500">Department</dt>
                        <dd class="mt-1 text-sm text-gray-900"><?php echo e($user->department->name); ?></dd>
                    </div>
                <?php endif; ?>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Status</dt>
                    <dd class="mt-1">
                        <span class="px-2 py-1 text-xs font-semibold rounded-full 
                            <?php if($user->status == 'active'): ?> bg-green-100 text-green-800
                            <?php elseif($user->status == 'inactive'): ?> bg-gray-100 text-gray-800
                            <?php else: ?> bg-red-100 text-red-800
                            <?php endif; ?>">
                            <?php echo e(ucfirst($user->status)); ?>

                        </span>
                    </dd>
                </div>
                <div>
                    <dt class="text-sm font-medium text-gray-500">Member Since</dt>
                    <dd class="mt-1 text-sm text-gray-900"><?php echo e($user->created_at->format('M d, Y')); ?></dd>
                </div>
            </dl>

            <!-- Assigned Units (for Trainers) -->
            <?php if($user->isTrainer()): ?>
                <div class="mt-6 pt-6 border-t border-gray-200">
                    <h3 class="text-sm font-semibold text-gray-900 mb-3">Assigned Units</h3>
                    <?php if(!$activeTerm): ?>
                        <p class="text-sm text-gray-500">No active term. Units will appear once a term is activated.</p>
                    <?php elseif(isset($assignedUnits) && $assignedUnits->count() > 0): ?>
                        <div class="flex flex-wrap gap-2">
                            <?php $__currentLoopData = $assignedUnits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="px-3 py-1 text-sm bg-purple-100 text-purple-800 rounded-full">
                                    <?php echo e($unit->name); ?>

                                    <?php if($unit->code): ?>
                                        <span class="text-purple-600">(<?php echo e($unit->code); ?>)</span>
                                    <?php endif; ?>
                                </span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <p class="text-sm text-gray-500">No units assigned for the current term.</p>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- Quick Stats -->
        <div class="bg-white rounded-xl shadow-md p-6">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Activity Summary</h2>
            <div class="space-y-4">
                <?php if($user->isStudent()): ?>
                    <div class="text-center p-4 bg-gray-50 rounded-lg">
                        <p class="text-2xl font-bold text-gray-900"><?php echo e($user->enrollments->count()); ?></p>
                        <p class="text-sm text-gray-600 mt-1">Enrolled Classes</p>
                    </div>
                    <div class="text-center p-4 bg-gray-50 rounded-lg">
                        <p class="text-2xl font-bold text-gray-900"><?php echo e($user->poeSubmissions->count()); ?></p>
                        <p class="text-sm text-gray-600 mt-1">Submissions</p>
                    </div>
                <?php elseif($user->isTrainer()): ?>
                    <div class="text-center p-4 bg-gray-50 rounded-lg">
                        <p class="text-2xl font-bold text-gray-900"><?php echo e(isset($assignedUnits) ? $assignedUnits->count() : 0); ?></p>
                        <p class="text-sm text-gray-600 mt-1">Assigned Units</p>
                        <?php if($activeTerm): ?>
                            <p class="text-xs text-gray-500 mt-1">(<?php echo e($activeTerm->name); ?>)</p>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Actions -->
            <div class="mt-6 pt-6 border-t border-gray-200 space-y-2">
                <a href="<?php echo e(route('hod.users.edit', $user)); ?>" class="block w-full text-center bg-purple-600 text-white px-4 py-2 rounded-lg hover:bg-purple-700 transition-colors font-medium">
                    Edit User
                </a>
                <?php if($user->id !== auth()->id()): ?>
                    <form action="<?php echo e(route('hod.users.destroy', $user)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to delete this user?');">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="block w-full text-center bg-red-600 text-white px-4 py-2 rounded-lg hover:bg-red-700 transition-colors font-medium">
                            Delete User
                        </button>
                    </form>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Student Enrollments (if student) -->
    <?php if($user->isStudent() && $user->enrollments->count() > 0): ?>
        <div class="bg-white rounded-xl shadow-md p-6">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Enrolled Classes</h2>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Class</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Term</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Enrolled</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php $__currentLoopData = $user->enrollments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $enrollment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e($enrollment->schoolClass->name); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($enrollment->schoolClass->term->name ?? 'N/A'); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">
                                        <?php echo e(ucfirst($enrollment->status)); ?>

                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    <?php echo e($enrollment->enrolled_at ? $enrollment->enrolled_at->format('M d, Y') : 'N/A'); ?>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif; ?>

    <!-- Submissions (if student) -->
    <?php if($user->isStudent() && $user->poeSubmissions->count() > 0): ?>
        <div class="bg-white rounded-xl shadow-md p-6">
            <h2 class="text-lg font-semibold text-gray-900 mb-4">Submissions</h2>
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Unit</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Class</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Status</th>
                            <th class="px-6 py-3 text-left text-xs font-semibold text-gray-600 uppercase">Submitted</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php $__currentLoopData = $user->poeSubmissions->take(10); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $submission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900"><?php echo e($submission->unit->name); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500"><?php echo e($submission->schoolClass->name); ?></td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-2 py-1 text-xs font-semibold rounded-full <?php echo e($submission->getStatusBadgeClasses()); ?>">
                                        <?php echo e(ucfirst(str_replace('_', ' ', $submission->status))); ?>

                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                    <?php echo e($submission->submitted_at ? $submission->submitted_at->format('M d, Y') : '-'); ?>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('layouts.hod', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\poe\resources\views/hod/users/show.blade.php ENDPATH**/ ?>